/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.stopmethods;

import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodMatcher;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.pitest.bytecode.analysis.InstructionMatchers;
import org.pitest.sequence.Context;
import org.pitest.sequence.Match;
import org.pitest.sequence.QueryStart;
import org.pitest.sequence.SequenceQuery;

public interface StopMethodMatchers {
    public static StopMethodMatcher isEnumGenerated() {
        return (classTree, methodTree) -> {
            ClassNode classNode = classTree.rawNode();
            if (!classNode.superName.equals("java/lang/Enum")) {
                return false;
            }
            MethodNode methodNode = methodTree.rawNode();
            if ((methodNode.access & 8) == 0) {
                return false;
            }
            String returnTypeDescription = "L" + classNode.name + ";";
            return StopMethodMatcher.matchesNameDesc(methodTree, "valueOf", "(Ljava/lang/String;)" + returnTypeDescription) || StopMethodMatcher.matchesNameDesc(methodTree, "values", "()[" + returnTypeDescription);
        };
    }

    public static StopMethodMatcher isToString() {
        return StopMethodMatcher.forNameDesc("toString", "()Ljava/lang/String;");
    }

    public static StopMethodMatcher isHashCode() {
        return StopMethodMatcher.forNameDesc("hashCode", "()I");
    }

    public static StopMethodMatcher isDeprecated() {
        return StopMethodMatcher.forAccess(131072);
    }

    public static StopMethodMatcher isEmptyVoid() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)177)));
    }

    public static StopMethodMatcher isSynthetic() {
        return (classTree, methodTree) -> methodTree.isSynthetic();
    }

    public static Match<AbstractInsnNode> opCodeBetween(final int lower, final int upper) {
        return new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode abstractInsnNode) {
                int opcode = abstractInsnNode.getOpcode();
                return opcode >= lower && opcode <= upper;
            }
        };
    }

    public static StopMethodMatcher isSimpleGetter() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)178)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(InstructionMatchers.opCode((int)180))).then(StopMethodMatchers.opCodeBetween(172, 177)));
    }

    public static StopMethodMatcher isSimpleSetter() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(StopMethodMatchers.opCodeBetween(21, 25)).then(InstructionMatchers.opCode((int)181)).or(QueryStart.match((Match)InstructionMatchers.opCode((int)21)).then(InstructionMatchers.opCode((int)179))).then(InstructionMatchers.opCode((int)177)));
    }

    public static StopMethodMatcher returnsAConstant() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match(StopMethodMatchers.opCodeBetween(1, 20)).then(StopMethodMatchers.opCodeBetween(172, 177)));
    }

    public static StopMethodMatcher isDelegate() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)25).or(InstructionMatchers.opCode((int)178))).or(QueryStart.match((Match)InstructionMatchers.opCode((int)25)).then(InstructionMatchers.opCode((int)180))).zeroOrMore(QueryStart.match(StopMethodMatchers.opCodeBetween(21, 45))).then((Match)new Match<AbstractInsnNode>(){

            public boolean test(Context<AbstractInsnNode> c, AbstractInsnNode abstractInsnNode) {
                int opcode = abstractInsnNode.getOpcode();
                return opcode == 182 || opcode == 183 || opcode == 185;
            }
        }).then(StopMethodMatchers.opCodeBetween(172, 177)));
    }

    public static StopMethodMatcher isStaticInitializer() {
        return StopMethodMatcher.forNameDesc("<clinit>", "()V");
    }

    public static StopMethodMatcher returnsAnEmptyArray() {
        return StopMethodMatcher.forBody((SequenceQuery<AbstractInsnNode>)QueryStart.match((Match)InstructionMatchers.opCode((int)3)).then(InstructionMatchers.opCode((int)188).or(InstructionMatchers.opCode((int)189))).then(InstructionMatchers.opCode((int)176)));
    }
}

