/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.reporting;

import eu.stamp_project.mutationtest.descartes.reporting.models.MethodClassification;
import eu.stamp_project.mutationtest.descartes.reporting.models.MethodRecord;
import eu.stamp_project.reloc.TagCreator;
import eu.stamp_project.reloc.tags.ContainerTag;
import eu.stamp_project.reloc.tags.DomContent;
import eu.stamp_project.reloc.tags.EmptyTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.stream.Collectors;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class IssuesReportListener
implements MutationResultListener {
    private ListenerArguments arguments;
    private long totalIssues = 0L;
    ContainerTag classList;

    public IssuesReportListener(ListenerArguments arguments) {
        this.arguments = arguments;
    }

    public void runStart() {
        this.classList = TagCreator.ul();
        this.totalIssues = 0L;
        this.transferCSS();
    }

    private Writer createFile(String path) {
        String filePath = Paths.get("issues", path).toString();
        return this.arguments.getOutputStrategy().createWriterForFile(filePath);
    }

    private void transferCSS() {
        try (Writer writer = this.createFile("style.css");){
            int read;
            InputStream originalCss = this.getClass().getClassLoader().getResourceAsStream("files/style.css");
            InputStreamReader reader = new InputStreamReader(originalCss);
            char[] buffer = new char[originalCss.available()];
            while ((read = reader.read(buffer)) >= 0) {
                writer.write(buffer, 0, read);
            }
            reader.close();
            writer.close();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMethod(MethodRecord method) {
        try (Writer writer = this.createFile(this.getFilePath(method));){
            String declaration = method.declaration();
            ContainerTag backLink = (ContainerTag)TagCreator.a("[Back]").withHref("../index.html");
            ContainerTag document = TagCreator.body(TagCreator.h1(declaration), backLink, TagCreator.dl(TagCreator.dt("Class"), TagCreator.dd(method.className()), TagCreator.dt("Package"), TagCreator.dd(method.packageName())), TagCreator.p(TagCreator.text("This method is "), TagCreator.strong(method.getClassification().toString())));
            document.with((DomContent)TagCreator.h2("Transformations"));
            if (method.getClassification() == MethodClassification.PARTIALLY_TESTED) {
                document.with((DomContent)TagCreator.p(TagCreator.text("It seems that this method has been tested to return only the following value(s): "), TagCreator.text(method.getUndetectedMutations().stream().map(mutation -> {
                    String mutator = mutation.getDetails().getMutator();
                    if (mutator.equals("empty")) {
                        return "an empty array";
                    }
                    return mutator;
                }).collect(Collectors.joining(", "))), TagCreator.text(".")));
            }
            if (method.isVoid()) {
                document.with((DomContent)TagCreator.p("To body of this method was removed but the test suite was not able to detect the transformation."));
            } else {
                document.with(TagCreator.p("The following transformations were applied but they were not detected by the test suite:"), TagCreator.ul(TagCreator.each(method.getUndetectedMutations(), mutation -> TagCreator.li(mutation.getDetails().getDescription()))));
            }
            if (method.getClassification() == MethodClassification.PARTIALLY_TESTED) {
                document.with(TagCreator.p("The following transformations were detected by the test suite when applied."), TagCreator.ul(TagCreator.each(method.getDetectedMutations(), mutation -> TagCreator.li(mutation.getDetails().getDescription()))));
            }
            document.with(TagCreator.h2("Tests"), TagCreator.p("The method is covered by the following test cases:"), TagCreator.ul(TagCreator.each(method.getTests(), test -> TagCreator.li(test.getName())))).with((DomContent)backLink);
            TagCreator.html(new DomContent[]{TagCreator.head(TagCreator.title(declaration)), ((EmptyTag)TagCreator.link().withHref("../style.css")).withRel("stylesheet")}).with((DomContent)document).render(writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMutationResult(ClassMutationResults classMutationResults) {
        ContainerTag methodList = TagCreator.ul();
        long issues = MethodRecord.getRecords(classMutationResults).filter(MethodRecord::hasIssues).peek(method -> {
            this.handleMethod((MethodRecord)method);
            methodList.with((DomContent)TagCreator.li(new DomContent[]{TagCreator.a(method.declaration()).withHref(this.getFilePath((MethodRecord)method)), TagCreator.text(" "), TagCreator.b(method.getClassification().toString())}));
        }).count();
        this.totalIssues += issues;
        if (issues == 0L) {
            return;
        }
        this.classList.with((DomContent)TagCreator.li(TagCreator.text(classMutationResults.getMutatedClass().asJavaName()), TagCreator.text(" ("), TagCreator.strong("Issues: "), TagCreator.text(Long.toString(issues) + ")")).with((DomContent)methodList));
    }

    private String getFilePath(MethodRecord method) {
        return Paths.get(method.getLocation().getClassName().asJavaName(), method.declaration() + ".html").toString();
    }

    private String getStringTime() {
        Duration ellapsed = Duration.ofMillis(System.currentTimeMillis() - this.arguments.getStartTime());
        String[] units = new String[]{"day", "hour", "minute", "second"};
        long[] parts = new long[]{ellapsed.toDays(), ellapsed.toHours() % 24L, ellapsed.toMinutes() % 60L, ellapsed.getSeconds() % 60L};
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == 0L) continue;
            result.append(parts[i]).append(" ").append(units[i]);
            if (parts[i] > 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        if (result.length() == 0) {
            return "less than one second";
        }
        return result.substring(0, result.length() - 1);
    }

    public void runEnd() {
        try (Writer writer = this.createFile("index.html");){
            TagCreator.html(TagCreator.head(new DomContent[]{TagCreator.title("Testing issues report"), ((EmptyTag)TagCreator.link().withHref("style.css")).withRel("stylesheet")}), TagCreator.body(TagCreator.h1("Issues Report"), TagCreator.dl(TagCreator.dt("Duration"), TagCreator.dd(this.getStringTime()), TagCreator.dt("Issues"), TagCreator.dd(Long.toString(this.totalIssues))), TagCreator.h2("Classes"), this.classList)).render(writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }
}

