/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.reporting;

import eu.stamp_project.mutationtest.descartes.reporting.JSONWriter;
import eu.stamp_project.mutationtest.descartes.reporting.models.MethodRecord;
import java.io.IOException;
import java.util.Collection;
import java.util.stream.Collectors;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class MethodTestingListener
implements MutationResultListener {
    private ListenerArguments args;
    private JSONWriter report;

    public MethodTestingListener(ListenerArguments args) {
        this.args = args;
    }

    public ListenerArguments getArguments() {
        return this.args;
    }

    public void runStart() {
        try {
            this.report = new JSONWriter(this.args.getOutputStrategy().createWriterForFile("methods.json"));
            this.report.beginObject();
            this.report.beginListAttribute("methods");
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMutationResult(ClassMutationResults results) {
        MethodRecord.getRecords(results).forEach(this::writeMethod);
    }

    private Collection<String> getMutators(Collection<MutationResult> mutations) {
        return mutations.stream().map(mutation -> mutation.getDetails().getMutator()).collect(Collectors.toList());
    }

    private void writeMethod(MethodRecord method) {
        try {
            this.report.beginObject();
            this.report.writeAttribute("name", method.name());
            this.report.writeAttribute("description", method.desc());
            this.report.writeAttribute("class", method.className());
            this.report.writeAttribute("package", method.packageName());
            this.report.writeAttribute("file-name", method.getFileName());
            this.report.writeAttribute("line-number", method.getLineNumber());
            this.report.writeAttribute("classification", method.getClassification().toString());
            this.report.writeStringListAttribute("detected", this.getMutators(method.getDetectedMutations()));
            this.report.writeStringListAttribute("not-detected", this.getMutators(method.getUndetectedMutations()));
            this.report.writeStringListAttribute("tests", method.getTests().stream().map(TestInfo::getName).collect(Collectors.toList()));
            this.report.beginListAttribute("mutations");
            method.getMutations().stream().forEach(this::writeMutationDetails);
            this.report.endList();
            this.report.endObject();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    private void writeMutationDetails(MutationResult mutation) {
        try {
            this.report.beginObject();
            this.report.writeAttribute("status", mutation.getStatus().name());
            this.report.writeAttribute("mutator", mutation.getDetails().getMutator());
            this.report.writeAttribute("tests-run", mutation.getNumberOfTestsRun());
            this.report.writeAttribute("detected-by", mutation.getKillingTest().orElse(""));
            this.report.beginListAttribute("tests");
            for (TestInfo test : mutation.getDetails().getTestsInOrder()) {
                this.report.write(test.getName());
            }
            this.report.endList();
            this.report.endObject();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void runEnd() {
        try {
            this.report.endList();
            this.report.beginObjectAttribute("analysis");
            this.report.writeAttribute("time", System.currentTimeMillis() - this.args.getStartTime());
            this.report.writeStringListAttribute("mutators", this.args.getEngine().getMutatorNames());
            this.report.endObject();
            this.report.endObject();
            this.report.close();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }
}

