/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.reloc.utils;

import eu.stamp_project.reloc.utils.CSSMin;
import eu.stamp_project.reloc.utils.IncompletePropertyException;
import eu.stamp_project.reloc.utils.Part;
import java.util.ArrayList;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

class Property
implements Comparable<Property> {
    private static final Logger LOG = Logger.getLogger(Property.class.getName());
    private String property;
    private Part[] parts;

    Property(String property) throws IncompletePropertyException {
        try {
            String substr;
            ArrayList<String> parts = new ArrayList<String>();
            boolean bCanSplit = true;
            int j = 0;
            if (CSSMin.debugLogging) {
                LOG.info("\t\tExamining property: " + property);
            }
            for (int i = 0; i < property.length(); ++i) {
                if (!bCanSplit) {
                    bCanSplit = property.charAt(i) == '\"';
                    continue;
                }
                if (property.charAt(i) == '\"') {
                    bCanSplit = false;
                    continue;
                }
                if (property.charAt(i) != ':' || !parts.isEmpty()) continue;
                substr = property.substring(j, i);
                if (!substr.trim().equals("")) {
                    parts.add(substr);
                }
                j = i + 1;
            }
            substr = property.substring(j, property.length());
            if (!substr.trim().equals("")) {
                parts.add(substr);
            }
            if (parts.size() < 2) {
                throw new IncompletePropertyException(property);
            }
            String prop = ((String)parts.get(0)).trim();
            if (prop.length() <= 2 || !prop.substring(0, 2).equals("--")) {
                prop = prop.toLowerCase();
            }
            this.property = prop;
            this.parts = this.parseValues(this.simplifyColours(((String)parts.get(1)).trim().replaceAll(", ", ",")));
        }
        catch (PatternSyntaxException patternSyntaxException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.property).append(":");
        for (Part p : this.parts) {
            sb.append(p.toString()).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(";");
        if (CSSMin.debugLogging) {
            LOG.info(sb.toString());
        }
        return sb.toString();
    }

    @Override
    public int compareTo(Property other) {
        return this.sort(this.property).compareTo(this.sort(other.property));
    }

    private String sort(String thisProp) {
        if (thisProp.charAt(0) == '-') {
            thisProp = thisProp.substring(1);
            thisProp = thisProp.substring(thisProp.indexOf(45) + 1);
        } else if (thisProp.charAt(0) < 'A') {
            thisProp = thisProp.substring(1);
        }
        return thisProp;
    }

    private Part[] parseValues(String contents) {
        String[] parts = contents.split(",");
        Part[] results = new Part[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            try {
                results[i] = new Part(parts[i], this.property);
                continue;
            }
            catch (Exception e) {
                LOG.warning(e.getMessage());
                results[i] = null;
            }
        }
        return results;
    }

    private String simplifyColours(String contents) {
        return this.simplifyRGBColours(contents);
    }

    private String simplifyRGBColours(String contents) {
        StringBuffer newContents = new StringBuffer();
        Pattern pattern = Pattern.compile("rgb\\s*\\(\\s*([0-9,\\s]+)\\s*\\)");
        Matcher matcher = pattern.matcher(contents);
        while (matcher.find()) {
            String[] rgbColours;
            StringBuffer hexColour = new StringBuffer("#");
            for (String rgbColour : rgbColours = matcher.group(1).split(",")) {
                int colourValue = Integer.parseInt(rgbColour);
                if (colourValue < 16) {
                    hexColour.append("0");
                }
                hexColour.append(Integer.toHexString(colourValue));
            }
            matcher.appendReplacement(newContents, hexColour.toString());
        }
        matcher.appendTail(newContents);
        return newContents.toString();
    }
}

