/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes;

import eu.stamp_project.mutationtest.descartes.DescartesMutationEngine;
import eu.stamp_project.mutationtest.descartes.MutationPointFinder;
import eu.stamp_project.mutationtest.descartes.codegeneration.MutationClassAdapter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Mutant;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.ClassVisitor;
import org.pitest.reloc.asm.ClassWriter;

public class DescartesMutater
implements Mutater {
    private final ClassByteArraySource byteSource;
    private final DescartesMutationEngine engine;

    public DescartesMutater(ClassByteArraySource byteSource, DescartesMutationEngine engine) {
        this.byteSource = byteSource;
        this.engine = engine;
    }

    public List<MutationDetails> findMutations(ClassName classToMutate) {
        Optional classBytes = this.byteSource.getBytes(classToMutate.asInternalName());
        if (!classBytes.isPresent()) {
            return Collections.emptyList();
        }
        return this.getMutationPoints(classToMutate, (byte[])classBytes.get());
    }

    private List<MutationDetails> getMutationPoints(ClassName className, byte[] classBytes) {
        ClassReader reader = new ClassReader(classBytes);
        MutationPointFinder finder = new MutationPointFinder(className, this.engine);
        reader.accept((ClassVisitor)finder, 0);
        return finder.getMutationPoints();
    }

    private byte[] createMutant(MutationIdentifier mID) {
        Optional bytes = this.byteSource.getBytes(mID.getClassName().asJavaName());
        ClassReader reader = new ClassReader((byte[])bytes.get());
        ClassWriter writer = new ClassWriter(3);
        MutationClassAdapter adapter = new MutationClassAdapter(mID, (ClassVisitor)writer);
        reader.accept((ClassVisitor)adapter, 0);
        return writer.toByteArray();
    }

    public Mutant getMutation(MutationIdentifier mID) {
        return new Mutant(new MutationDetails(mID, "", "", 0, 0), this.createMutant(mID));
    }
}

