/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.reporting;

import eu.stamp_project.mutationtest.descartes.reporting.models.MethodClassification;
import eu.stamp_project.mutationtest.descartes.reporting.models.MethodRecord;
import j2html.TagCreator;
import j2html.tags.ContainerTag;
import j2html.tags.DomContent;
import j2html.tags.EmptyTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.stream.Collectors;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResultListener;
import org.pitest.util.Unchecked;

public class IssuesReportListener
implements MutationResultListener {
    private ListenerArguments arguments;
    private long totalIssues = 0L;
    ContainerTag classList;

    public IssuesReportListener(ListenerArguments arguments) {
        this.arguments = arguments;
    }

    public void runStart() {
        this.classList = TagCreator.ul();
        this.totalIssues = 0L;
        this.transferCSS();
    }

    private Writer createFile(String path) {
        String filePath = Paths.get("issues", path).toString();
        return this.arguments.getOutputStrategy().createWriterForFile(filePath);
    }

    private void transferCSS() {
        try (Writer writer = this.createFile("style.css");){
            int read;
            InputStream originalCss = this.getClass().getClassLoader().getResourceAsStream("files/style.css");
            InputStreamReader reader = new InputStreamReader(originalCss);
            char[] buffer = new char[originalCss.available()];
            while ((read = reader.read(buffer)) >= 0) {
                writer.write(buffer, 0, read);
            }
            reader.close();
            writer.close();
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMethod(MethodRecord method) {
        try (Writer writer = this.createFile(this.getFilePath(method));){
            String declaration = method.declaration();
            ContainerTag backLink = (ContainerTag)TagCreator.a((String)"[Back]").withHref("../index.html");
            ContainerTag document = TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)declaration), backLink, TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Class"), TagCreator.dd((String)method.className()), TagCreator.dt((String)"Package"), TagCreator.dd((String)method.packageName())}), TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"This method is "), TagCreator.strong((String)method.getClassification().toString())})});
            document.with((DomContent)TagCreator.h2((String)"Transformations"));
            if (method.getClassification() == MethodClassification.PARTIALLY_TESTED) {
                document.with((DomContent)TagCreator.p((DomContent[])new DomContent[]{TagCreator.text((String)"It seems that this method has been tested to return only the following value(s): "), TagCreator.text((String)method.getUndetectedMutations().stream().map(mutation -> {
                    String mutator = mutation.getDetails().getMutator();
                    if (mutator.equals("empty")) {
                        return "an empty array";
                    }
                    return mutator;
                }).collect(Collectors.joining(", "))), TagCreator.text((String)".")}));
            }
            if (method.isVoid()) {
                document.with((DomContent)TagCreator.p((String)"To body of this method was removed but the test suite was not able to detect the transformation."));
            } else {
                document.with(new DomContent[]{TagCreator.p((String)"The following transformations were applied but they were not detected by the test suite:"), TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each(method.getUndetectedMutations(), mutation -> TagCreator.li((String)mutation.getDetails().getDescription()))})});
            }
            if (method.getClassification() == MethodClassification.PARTIALLY_TESTED) {
                document.with(new DomContent[]{TagCreator.p((String)"The following transformations were detected by the test suite when applied."), TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each(method.getDetectedMutations(), mutation -> TagCreator.li((String)mutation.getDetails().getDescription()))})});
            }
            document.with(new DomContent[]{TagCreator.h2((String)"Tests"), TagCreator.p((String)"The method is covered by the following test cases:"), TagCreator.ul((DomContent[])new DomContent[]{TagCreator.each(method.getTests(), test -> TagCreator.li((String)test.getName()))})}).with((DomContent)backLink);
            TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)declaration)}), ((EmptyTag)TagCreator.link().withHref("../style.css")).withRel("stylesheet")}).with((DomContent)document).render((Appendable)writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }

    public void handleMutationResult(ClassMutationResults classMutationResults) {
        ContainerTag methodList = TagCreator.ul();
        long issues = MethodRecord.getRecords(classMutationResults).filter(MethodRecord::hasIssues).peek(method -> {
            this.handleMethod((MethodRecord)method);
            methodList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.a((String)method.declaration()).withHref(this.getFilePath((MethodRecord)method)), TagCreator.text((String)" "), TagCreator.b((String)method.getClassification().toString())}));
        }).count();
        this.totalIssues += issues;
        if (issues == 0L) {
            return;
        }
        this.classList.with((DomContent)TagCreator.li((DomContent[])new DomContent[]{TagCreator.text((String)classMutationResults.getMutatedClass().asJavaName()), TagCreator.text((String)" ("), TagCreator.strong((String)"Issues: "), TagCreator.text((String)(Long.toString(issues) + ")"))}).with((DomContent)methodList));
    }

    private String getFilePath(MethodRecord method) {
        return Paths.get(method.getLocation().getClassName().asJavaName(), method.declaration() + ".html").toString();
    }

    private String getStringTime() {
        Duration ellapsed = Duration.ofMillis(System.currentTimeMillis() - this.arguments.getStartTime());
        String[] units = new String[]{"day", "hour", "minute", "second"};
        long[] parts = new long[]{ellapsed.toDays(), ellapsed.toHours() % 24L, ellapsed.toMinutes() % 60L, ellapsed.getSeconds() % 60L};
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i] == 0L) continue;
            result.append(parts[i]).append(" ").append(units[i]);
            if (parts[i] > 1L) {
                result.append("s");
            }
            result.append(" ");
        }
        if (result.length() == 0) {
            return "less than one second";
        }
        return result.substring(0, result.length() - 1);
    }

    public void runEnd() {
        try (Writer writer = this.createFile("index.html");){
            TagCreator.html((DomContent[])new DomContent[]{TagCreator.head((DomContent[])new DomContent[]{TagCreator.title((String)"Testing issues report"), ((EmptyTag)TagCreator.link().withHref("style.css")).withRel("stylesheet")}), TagCreator.body((DomContent[])new DomContent[]{TagCreator.h1((String)"Issues Report"), TagCreator.dl((DomContent[])new DomContent[]{TagCreator.dt((String)"Duration"), TagCreator.dd((String)this.getStringTime()), TagCreator.dt((String)"Issues"), TagCreator.dd((String)Long.toString(this.totalIssues))}), TagCreator.h2((String)"Classes"), this.classList})}).render((Appendable)writer);
        }
        catch (IOException exc) {
            throw Unchecked.translateCheckedException((Throwable)exc);
        }
    }
}

