/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project;

import eu.stamp_project.plugins.PmpProject;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.DirectoryClassPathRoot;
import org.pitest.maven.PmpMojo;

public class PmpContext {
    protected static PmpContext _Instance = null;
    protected List<MavenProject> _Modules = null;
    protected PmpProject _CurrentProject = null;

    public static PmpContext getInstance() {
        if (_Instance == null) {
            _Instance = new PmpContext();
        }
        return _Instance;
    }

    public List<MavenProject> getModules() {
        return this._Modules;
    }

    protected void setModules(List<MavenProject> value) {
        this._Modules = value;
    }

    public PmpProject getCurrentProject() {
        return this._CurrentProject;
    }

    public void setCurrentProject(PmpProject value) {
        this._CurrentProject = value;
    }

    public static void addNewStrings(List<String> targetList, List<String> listToAdd) {
        for (String currentElt : listToAdd) {
            if (targetList.contains(currentElt)) continue;
            targetList.add(currentElt);
        }
    }

    public static ArrayList<File> stringsToFiles(ArrayList<String> nameList) {
        ArrayList<File> fileList = new ArrayList<File>();
        for (int i = 0; i < nameList.size(); ++i) {
            File newFile = new File(nameList.get(i));
            if (!newFile.exists()) continue;
            fileList.add(newFile);
        }
        return fileList;
    }

    public static Boolean oneFileExists(List<String> fileNameList) {
        Iterator<String> myIt = fileNameList.iterator();
        Boolean result = false;
        while (myIt.hasNext() && !result.booleanValue()) {
            String currentName = myIt.next();
            File theFile = new File(currentName);
            result = theFile.exists();
        }
        return result;
    }

    public static ArrayList<String> getClasses(MavenProject theProject) {
        return PmpContext.getClassesInternal(theProject.getBuild().getOutputDirectory());
    }

    public static ArrayList<String> getTestClasses(MavenProject theProject) {
        return PmpContext.getClassesInternal(theProject.getBuild().getTestOutputDirectory());
    }

    private static ArrayList<String> getClassesInternal(String buildOutputDirectory) {
        ArrayList classList = new ArrayList();
        ArrayList<String> classFilterList = new ArrayList<String>();
        File outputDir = new File(buildOutputDirectory);
        if (outputDir.exists()) {
            DirectoryClassPathRoot classRoot = new DirectoryClassPathRoot(outputDir);
            classList.addAll(classRoot.classNames());
            Iterator myIt = classList.iterator();
            while (myIt.hasNext()) {
                String aFilter = ClassName.fromString((String)((String)myIt.next())).getPackage().asJavaName() + ".*";
                if (classFilterList.contains(aFilter)) continue;
                classFilterList.add(aFilter);
            }
        }
        return classFilterList;
    }

    public void updateData(PmpMojo mojo) {
        List<MavenProject> moduleList = this.getProjectModules(mojo);
        if (this.getModules() == null) {
            this.setModules(moduleList);
        }
    }

    public List<MavenProject> getProjectModules(PmpMojo mojo) {
        List moduleList = mojo.getProject().getCollectedProjects();
        return moduleList;
    }

    public ArrayList<MavenProject> getDependingModules(MavenProject aProject) {
        ArrayList<MavenProject> moduleList = new ArrayList<MavenProject>();
        Set allDepend = aProject.getArtifacts();
        for (Artifact currentArtifact : allDepend) {
            MavenProject aModule = this.getMavenProjectFromName(currentArtifact.getArtifactId());
            if (aModule == null) continue;
            moduleList.add(aModule);
        }
        return moduleList;
    }

    public Boolean isProjectModule(String name) {
        Iterator<MavenProject> myIt = this.getModules().iterator();
        Boolean result = false;
        while (myIt.hasNext() && !result.booleanValue()) {
            MavenProject currentModule = myIt.next();
            result = currentModule.getArtifactId().equals(name);
        }
        return result;
    }

    public MavenProject getMavenProjectFromName(String name) {
        Iterator<MavenProject> myIt = this.getModules().iterator();
        MavenProject module = null;
        while (myIt.hasNext() && module == null) {
            MavenProject currentModule = myIt.next();
            if (!currentModule.getArtifactId().equals(name)) continue;
            module = currentModule;
        }
        return module;
    }

    public static void printCollectedProjects(MavenProject aProject) {
        List collectedProjects = aProject.getCollectedProjects();
        System.out.print("#### collectedProjects(" + aProject.getArtifactId() + "): ");
        if (collectedProjects != null) {
            for (MavenProject currentModule : collectedProjects) {
                System.out.print(currentModule.getArtifactId() + ", ");
            }
        }
        System.out.println("");
    }

    public static void printArtifacts(MavenProject aProject) {
        Set dependProjects = aProject.getArtifacts();
        System.out.print("#### artifacts(" + aProject.getArtifactId() + "): ");
        if (dependProjects != null) {
            for (Artifact currentModule : dependProjects) {
                System.out.print(currentModule.getArtifactId() + ", ");
            }
        }
        System.out.println("");
    }

    public static void printDependModules(MavenProject aProject, ArrayList<MavenProject> moduleList) {
        System.out.print("#### dependModules(" + aProject.getArtifactId() + "): ");
        if (moduleList != null) {
            for (MavenProject currentModule : moduleList) {
                System.out.print(currentModule.getArtifactId() + ", ");
            }
        }
        System.out.println("");
    }
}

