/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.report;

import eu.stamp_project.mutationtest.descartes.reporting.models.MethodRecord;
import eu.stamp_project.report.MethodThresholds;
import org.pitest.mutationtest.ClassMutationResults;
import org.pitest.mutationtest.ListenerArguments;
import org.pitest.mutationtest.MutationResultListener;

public class PseudoPartialyTestingListener
implements MutationResultListener {
    private Integer tested = 0;
    private Integer notCovered = 0;
    private Integer pseudoTested = 0;
    private Integer partiallyTested = 0;
    private ListenerArguments args;

    public PseudoPartialyTestingListener(ListenerArguments args) {
        this.args = args;
    }

    public ListenerArguments getArguments() {
        return this.args;
    }

    public void runStart() {
    }

    public void handleMutationResult(ClassMutationResults results) {
        MethodRecord.getRecords((ClassMutationResults)results).forEach(this::checkMethod);
    }

    public void runEnd() {
        this.throwErrorIfPseudoTestedAboveThreshold(this.pseudoTested);
        this.throwErrorIfPartiallyTestedAboveThreshold(this.partiallyTested);
    }

    private void throwErrorIfPartiallyTestedAboveThreshold(Integer partiallyTested) {
        if (MethodThresholds.getInstance().getPartialyTestedThresold() != 0 && partiallyTested > MethodThresholds.getInstance().getPartialyTestedThresold()) {
            throw new RuntimeException("Partially Tested score of " + partiallyTested + " is above threshold of " + MethodThresholds.getInstance().getPartialyTestedThresold());
        }
    }

    private void throwErrorIfPseudoTestedAboveThreshold(Integer psedudoTested) {
        if (MethodThresholds.getInstance().getPseudoTestedThresold() != 0 && psedudoTested > MethodThresholds.getInstance().getPseudoTestedThresold()) {
            throw new RuntimeException("Pseudo Tested score of " + psedudoTested + " is above threshold of " + MethodThresholds.getInstance().getPseudoTestedThresold());
        }
    }

    private void checkMethod(MethodRecord method) {
        switch (method.getClassification()) {
            case TESTED: {
                Integer n = this.tested;
                Integer n2 = this.tested = Integer.valueOf(this.tested + 1);
                break;
            }
            case NOT_COVERED: {
                Integer n = this.notCovered;
                Integer n3 = this.notCovered = Integer.valueOf(this.notCovered + 1);
                break;
            }
            case PSEUDO_TESTED: {
                Integer n = this.pseudoTested;
                Integer n4 = this.pseudoTested = Integer.valueOf(this.pseudoTested + 1);
                break;
            }
            case PARTIALLY_TESTED: {
                Integer n = this.partiallyTested;
                Integer n5 = this.partiallyTested = Integer.valueOf(this.partiallyTested + 1);
            }
        }
    }
}

