/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.Switch;
import com.martiansoftware.util.StringUtils;
import java.util.Iterator;
import java.util.List;

public class SimpleJSAP
extends JSAP {
    private int screenWidth = 80;
    private String explanation;
    private boolean messagePrinted;
    private final String name;

    public SimpleJSAP(String string, String string2, Parameter[] parameterArray) throws JSAPException {
        this.name = string;
        this.explanation = string2;
        Switch switch_ = new Switch("help", '\u0000', "help");
        switch_.setHelp("Prints this help message.");
        this.registerParameter(switch_);
        if (parameterArray != null) {
            for (int j = 0; j < parameterArray.length; ++j) {
                this.registerParameter(parameterArray[j]);
            }
        }
    }

    public SimpleJSAP(String string, String string2) throws JSAPException {
        this(string, string2, null);
    }

    public SimpleJSAP(String string) throws JSAPException {
        this(string, null);
    }

    public JSAPResult parse(String string) {
        JSAPResult jSAPResult = super.parse(string);
        this.messagePrinted = this.printMessageIfUnsuccessfulOrHelpRequired(jSAPResult);
        return jSAPResult;
    }

    public JSAPResult parse(String[] stringArray) {
        JSAPResult jSAPResult = super.parse(stringArray);
        this.messagePrinted = this.printMessageIfUnsuccessfulOrHelpRequired(jSAPResult);
        return jSAPResult;
    }

    private boolean printMessageIfUnsuccessfulOrHelpRequired(JSAPResult jSAPResult) {
        if (!jSAPResult.success() || jSAPResult.getBoolean("help")) {
            if (!jSAPResult.getBoolean("help")) {
                Iterator iterator = jSAPResult.getErrorMessageIterator();
                while (iterator.hasNext()) {
                    System.err.println("Error: " + iterator.next());
                }
                return true;
            }
            System.err.println();
            System.err.println("Usage:");
            List list = StringUtils.wrapToList(this.name + " " + this.getUsage(), this.screenWidth);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                System.err.println("  " + iterator.next().toString());
            }
            if (this.explanation != null) {
                System.err.println();
                list = StringUtils.wrapToList(this.explanation, this.screenWidth);
                iterator = list.iterator();
                while (iterator.hasNext()) {
                    System.err.println(iterator.next());
                }
            }
            System.err.println();
            System.err.println();
            System.err.println(this.getHelp(this.screenWidth));
            return true;
        }
        return false;
    }

    public int getScreenWidth() {
        return this.screenWidth;
    }

    public SimpleJSAP setScreenWidth(int n) {
        this.screenWidth = n;
        return this;
    }

    public boolean messagePrinted() {
        return this.messagePrinted;
    }
}

