/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes;

import eu.stamp_project.mutationtest.descartes.DescartesMutater;
import eu.stamp_project.mutationtest.descartes.operators.MutationOperator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.reloc.asm.commons.Method;

public class DescartesMutationEngine
implements MutationEngine {
    private final Predicate<Method> excludedMethods;
    private final Collection<MutationOperator> operators;

    public DescartesMutationEngine(Collection<MutationOperator> operators) {
        this((Method m) -> false, operators);
    }

    public DescartesMutationEngine(MutationOperator ... operators) {
        this(Arrays.asList(operators));
    }

    public DescartesMutationEngine(Predicate<Method> excludedMethods, MutationOperator ... operators) {
        this(excludedMethods, Arrays.asList(operators));
    }

    public DescartesMutationEngine(Predicate<Method> excludedMethods, Collection<MutationOperator> operators) {
        if (excludedMethods == null) {
            throw new IllegalArgumentException("excludedMethod argument can not be null");
        }
        if (operators == null) {
            throw new IllegalArgumentException("operators argument can not be null");
        }
        this.excludedMethods = excludedMethods;
        this.operators = operators;
    }

    @Override
    public Mutater createMutator(ClassByteArraySource byteSource) {
        return new DescartesMutater(byteSource, this);
    }

    @Override
    public Collection<String> getMutatorNames() {
        return this.operators.stream().map(op -> op.getID()).collect(Collectors.toList());
    }

    public Collection<MutationOperator> getOperatorsFor(Method method) {
        if (this.excludedMethods.test(method)) {
            return Collections.emptyList();
        }
        return this.operators.stream().filter(op -> op.canMutate(method)).collect(Collectors.toList());
    }

    public String toString() {
        return "DescartesMutationEngine";
    }

    @Override
    public String getName() {
        return "descartes";
    }
}

