/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.bodyanalysis;

import java.util.NoSuchElementException;

public class LineCounter {
    private int firstLine;
    private int lastLine;

    public LineCounter() {
        this.reset();
    }

    public void reset() {
        this.firstLine = Integer.MAX_VALUE;
        this.lastLine = Integer.MIN_VALUE;
    }

    public void registerLine(int line) {
        this.firstLine = Math.min(this.firstLine, line);
        this.lastLine = Math.max(this.lastLine, line);
    }

    public boolean empty() {
        return this.firstLine > this.lastLine;
    }

    public int getCount() {
        if (this.empty()) {
            return 0;
        }
        return this.lastLine - this.firstLine + 1;
    }

    public int getFirstLine() {
        if (this.empty()) {
            throw new NoSuchElementException("Attempt to grab a line from an empty interval.");
        }
        return this.firstLine;
    }

    public int getLastLine() {
        if (this.empty()) {
            throw new NoSuchElementException("Attempt to grab a line from an empty interval.");
        }
        return this.lastLine;
    }
}

