/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators;

import eu.stamp_project.mutationtest.descartes.operators.MutationOperator;
import eu.stamp_project.utils.TypeHelper;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;
import org.pitest.reloc.asm.commons.Method;

public class ConstantMutationOperator
extends MutationOperator {
    private final Object constant;
    private final String id;

    public ConstantMutationOperator(String id, Object constant) {
        if (!TypeHelper.isConstantType(constant.getClass())) {
            throw new IllegalArgumentException();
        }
        this.constant = constant;
        this.id = id;
    }

    public Object getConstant() {
        return this.constant;
    }

    @Override
    public boolean canMutate(Method method) {
        Type methodType = method.getReturnType();
        int typeSort = methodType.getSort();
        Type constantType = Type.getType(this.constant.getClass());
        if (typeSort == 9 || typeSort == 11) {
            return false;
        }
        if (typeSort == 10) {
            return constantType.equals(methodType);
        }
        return methodType.equals(constantType) || methodType.equals(this.unwrapType(this.constant.getClass()));
    }

    @Override
    public void generateCode(Method method, MethodVisitor mv) {
        assert (this.canMutate(method));
        mv.visitLdcInsn(this.constant);
        Type methodType = method.getReturnType();
        Type constantType = Type.getType(this.constant.getClass());
        if (this.constant.getClass() != String.class && methodType.equals(constantType)) {
            String target = methodType.getInternalName();
            String descriptor = String.format("(%s)L%s;", this.unwrapType(this.constant.getClass()).getInternalName(), target);
            mv.visitMethodInsn(184, target, "valueOf", descriptor, false);
            mv.visitInsn(176);
        } else {
            mv.visitInsn(methodType.getOpcode(172));
        }
    }

    private Type unwrapType(Class<?> type) {
        return Type.getType(TypeHelper.unwrap(this.constant.getClass()));
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return "All method body replaced by: return " + this.id;
    }
}

