/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.operators.parsing;

import eu.stamp_project.mutationtest.descartes.operators.parsing.Token;
import eu.stamp_project.mutationtest.descartes.operators.parsing.TokenType;
import eu.stamp_project.utils.Converter;
import java.io.IOException;
import java.io.Reader;

class OperatorLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 16384;
    public static final int YYINITIAL = 0;
    public static final int STRING = 2;
    public static final int CHAR = 4;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2};
    private static final String ZZ_CMAP_PACKED = "\b\u0000\u0002+\u0001*\u0001,\u0001,\u0001*\u0012\u0000\u0001'\u0001\u0000\u0001&\u0004\u0000\u0001%\u0001 \u0001!\u0001\u0000\u0001\u000f\u0001\u0000\u0001$\u0001\r\u0001\u0000\u0001\u0001\u0001\u000b\u0002)\u0004\t\u0002\u0002\u0007\u0000\u0001\u0007\u0001\n\u0002\u0007\u0001\u000e\u0001\f\u0005\u0000\u0001\u0005\u000b\u0000\u0001\u0006\u0003\u0000\u0001(\u0002\u0000\u0001\u0003\u0001\u0000\u0001\u0018\u0001\"\u0001\u0007\u0001\u0016\u0001\u001a\u0001\u0017\u0001\u0000\u0001#\u0001\u0015\u0002\u0000\u0001\u0012\u0001\u001d\u0001\u0010\u0001\u0014\u0001\u001e\u0001\u0000\u0001\u001c\u0001\u0019\u0001\u001b\u0001\u0011\u0001\u0013\u0001\u0000\u0001\u0006\u0001\u001f\u000b\u0000\u0001,\u05da\u0000\n\u0004\u0086\u0000\n\u0004\u00c6\u0000\n\u0004\u019c\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004`\u0000\n\u0004v\u0000\n\u0004F\u0000\n\u0004\u0116\u0000\n\u0004F\u0000\n\u0004\u0746\u0000\n\u0004&\u0000\n\u0004\u012c\u0000\n\u0004\u0080\u0000\n\u0004\u00a6\u0000\n\u0004\u0006\u0000\n\u0004\u00b6\u0000\n\u0004V\u0000\n\u0004\u0086\u0000\n\u0004\u0006\u0000\n\u0004\u03ce\u0000\u0001,\u0001,\u85f6\u0000\n\u0004\u02a6\u0000\n\u0004&\u0000\n\u0004\u00c6\u0000\n\u0004\u0016\u0000\n\u0004V\u0000\n\u0004\u0196\u0000\n\u0004\u5316\u0000\n\b\u0007\u0000\u0006\u0007\u001a\u0000\u0006\u0007\u0559\u0000\n\u0004\u0bbc\u0000\n\u0004\u0080\u0000\n\u0004<\u0000\n\u0004\u0090\u0000\n\u0004\u0116\u0000\n\u0004\u01d6\u0000\n\u0004\u0176\u0000\n\u0004f\u0000\n\u0004\u0216\u0000\n\u0004\u5176\u0000\n\u0004\u00e6\u0000\n\u0004\u6c74\u00002\u0004\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\u280f\u0000";
    private static final char[] ZZ_CMAP = OperatorLexer.zzUnpackCMap("\b\u0000\u0002+\u0001*\u0001,\u0001,\u0001*\u0012\u0000\u0001'\u0001\u0000\u0001&\u0004\u0000\u0001%\u0001 \u0001!\u0001\u0000\u0001\u000f\u0001\u0000\u0001$\u0001\r\u0001\u0000\u0001\u0001\u0001\u000b\u0002)\u0004\t\u0002\u0002\u0007\u0000\u0001\u0007\u0001\n\u0002\u0007\u0001\u000e\u0001\f\u0005\u0000\u0001\u0005\u000b\u0000\u0001\u0006\u0003\u0000\u0001(\u0002\u0000\u0001\u0003\u0001\u0000\u0001\u0018\u0001\"\u0001\u0007\u0001\u0016\u0001\u001a\u0001\u0017\u0001\u0000\u0001#\u0001\u0015\u0002\u0000\u0001\u0012\u0001\u001d\u0001\u0010\u0001\u0014\u0001\u001e\u0001\u0000\u0001\u001c\u0001\u0019\u0001\u001b\u0001\u0011\u0001\u0013\u0001\u0000\u0001\u0006\u0001\u001f\u000b\u0000\u0001,\u05da\u0000\n\u0004\u0086\u0000\n\u0004\u00c6\u0000\n\u0004\u019c\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004v\u0000\n\u0004`\u0000\n\u0004v\u0000\n\u0004F\u0000\n\u0004\u0116\u0000\n\u0004F\u0000\n\u0004\u0746\u0000\n\u0004&\u0000\n\u0004\u012c\u0000\n\u0004\u0080\u0000\n\u0004\u00a6\u0000\n\u0004\u0006\u0000\n\u0004\u00b6\u0000\n\u0004V\u0000\n\u0004\u0086\u0000\n\u0004\u0006\u0000\n\u0004\u03ce\u0000\u0001,\u0001,\u85f6\u0000\n\u0004\u02a6\u0000\n\u0004&\u0000\n\u0004\u00c6\u0000\n\u0004\u0016\u0000\n\u0004V\u0000\n\u0004\u0196\u0000\n\u0004\u5316\u0000\n\b\u0007\u0000\u0006\u0007\u001a\u0000\u0006\u0007\u0559\u0000\n\u0004\u0bbc\u0000\n\u0004\u0080\u0000\n\u0004<\u0000\n\u0004\u0090\u0000\n\u0004\u0116\u0000\n\u0004\u01d6\u0000\n\u0004\u0176\u0000\n\u0004f\u0000\n\u0004\u0216\u0000\n\u0004\u5176\u0000\n\u0004\u00e6\u0000\n\u0004\u6c74\u00002\u0004\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\u280f\u0000");
    private static final int[] ZZ_ACTION = OperatorLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0002\u0002\u0001\u0003\u0007\u0001\u0001\u0004\u0001\u0005\u0001\u0001\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\n\u0001\u000b\u0003\u0001\u0001\u0000\u0001\f\u0001\u0000\u0001\r\u0002\u0000\u0001\u000e\u0001\u0003\t\u0000\u0002\u000f\u0001\u0010\u0001\u0000\u0001\u0011\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0016\u0001\u0017\u0001\u0018\n\u0000\u0001\u0019\u0001\f\u0001\u001a\u0001\u001b\u0001\u0003\u0001\u0000\u0001\u0002\u0007\u0000\u0001\u000f\u0002\u0000\u0001\u001c\u0001\u001d\u0001\u0000\u0001\u001e\u0001\u001f\u0001 \u0001!\u0001\"\u0001#\u0001\u0000\u0001$\u0001\u0000\u0001%\u0001&\u0001'\u0003\u0000\u0001(\u0001)\u0002\u0000\u0001*\u0001+\u0001,\u0002\u0000\u0001-\u0001\u0000\u0001.";
    private static final int[] ZZ_ROWMAP = OperatorLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000-\u0000Z\u0000\u0087\u0000\u00b4\u0000\u00e1\u0000\u010e\u0000\u013b\u0000\u0168\u0000\u0195\u0000\u01c2\u0000\u01ef\u0000\u021c\u0000\u0249\u0000\u0087\u0000\u0087\u0000\u0276\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u02a3\u0000\u02d0\u0000\u0087\u0000\u02fd\u0000\u032a\u0000\u0357\u0000\u032a\u0000\u0384\u0000\u03b1\u0000\u0087\u0000\u03de\u0000\u040b\u0000\u0087\u0000\u0438\u0000\u0465\u0000\u0492\u0000\u04bf\u0000\u04ec\u0000\u0519\u0000\u0546\u0000\u0573\u0000\u05a0\u0000\u05cd\u0000\u05fa\u0000\u0627\u0000\u0087\u0000\u0654\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0681\u0000\u06ae\u0000\u06db\u0000\u0708\u0000\u0735\u0000\u0762\u0000\u078f\u0000\u07bc\u0000\u07e9\u0000\u0816\u0000\u0087\u0000\u0843\u0000\u0870\u0000\u089d\u0000\u08ca\u0000\u08f7\u0000\u0924\u0000\u0951\u0000\u097e\u0000\u09ab\u0000\u09d8\u0000\u0a05\u0000\u0a32\u0000\u0a5f\u0000\u0087\u0000\u0a8c\u0000\u0ab9\u0000\u0087\u0000\u0087\u0000\u0ae6\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0b13\u0000\u0087\u0000\u0b40\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0b6d\u0000\u0b9a\u0000\u0bc7\u0000\u0087\u0000\u0087\u0000\u0bf4\u0000\u0c21\u0000\u0087\u0000\u0087\u0000\u0087\u0000\u0c4e\u0000\u0c7b\u0000\u0087\u0000\u0ca8\u0000\u0087";
    private static final int[] ZZ_TRANS = OperatorLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0004\u0001\u0005\u0001\u0006\u0001\u0004\u0001\u0007\u0003\u0004\u0001\u0007\u0001\u0006\u0001\u0004\u0001\u0006\u0001\u0004\u0001\b\u0002\u0004\u0001\t\u0002\u0004\u0001\n\u0003\u0004\u0001\u000b\u0001\u0004\u0001\f\u0001\r\u0001\u000e\u0004\u0004\u0001\u000f\u0001\u0010\u0001\u0011\u0001\u0004\u0001\u0012\u0001\u0013\u0001\u0014\u0001\u0015\u0001\u0004\u0001\u0006\u0002\u0015\u0001\u0000&\u0016\u0001\u0017\u0001\u0016\u0001\u0018\u0001\u0016\u0001\u0000\u0002\u0016%\u0019\u0001\u0004\u0002\u0019\u0001\u001a\u0001\u0019\u0001\u0000\u0001\u0004\u0001\u001b.\u0000\u0001\u001c\u0001\u0007\u0001\u001d\u0001\u0007\u0001\u001e\u0001\u001f\u0001\u0000\u0001\u0007\u0001\u001c\u0001 \u0001\u001c\u0001!\u0001\"\u0001#\u0003\u0000\u0001\u001e\u0004\u0000\u0001!\u0002\u0000\u0001#\u0007\u0000\u0001 \u0006\u0000\u0001\u001c\u0004\u0000\u0002\u0006\u0001$\u0001\u0006\u0001\u001e\u0002\u0000\u0002\u0006\u0001\u0000\u0001\u0006\u0001!\u0001\"\u0001#\u0003\u0000\u0001\u001e\u0004\u0000\u0001!\u0002\u0000\u0001#\u000e\u0000\u0001\u0006\u0004\u0000\u0002\u0007\u0001\u0000\u0001\u0007\u0003\u0000\u0002\u0007\u0001\u0000\u0001\u0007\u0001!\u0001\"\u0001#\b\u0000\u0001!\u0002\u0000\u0001#\u000e\u0000\u0001\u0007\u0004\u0000\u0002\"\u0001\u0000\u0001\"\u0003\u0000\u0002\"\u0001\u0000\u0001\"\u001d\u0000\u0001\"\u0014\u0000\u0001%/\u0000\u0001&0\u0000\u0001'7\u0000\u0001(&\u0000\u0001)+\u0000\u0001*/\u0000\u0001+4\u0000\u0001\u0015\u0002\u0000\u0002\u0015\u0001\u0000&\u0016\u0001\u0000\u0001\u0016\u0001\u0000\u0001\u0016\u0001\u0000\u0002\u0016\u0001\u0000\u0001,\u0007\u0000\u0001-\u0001\u0000\u0001,\u0004\u0000\u0001.\u0001/\u0005\u0000\u00010\u0003\u0000\u00011\u00012\u0005\u0000\u00013\u0002\u0000\u00014\u00015\u0001\u0000\u00016\u0001,(\u0000\u00017\b\u0000\u00018\u0007\u0000\u00018\u0001\u0000\u00019\u0004\u0000\u0001:\u0001;\u0005\u0000\u0001<\u0003\u0000\u0001=\u0001>\u0005\u0000\u0001?\u0002\u0000\u0001@\u0002\u0000\u0001A\u00019\u0004\u0000\u0001\u001c\u0001\u0007\u0001\u001d\u0001\u0007\u0001B\u0002\u0000\u0001\u0007\u0001\u001c\u0001\u0000\u0001\u001c\u0001!\u0001\"\u0001#\u0003\u0000\u0001B\u0004\u0000\u0001!\u0002\u0000\u0001#\u000e\u0000\u0001\u001c\u0004\u0000\u0001C\u0001\u0000\u0001\u001d\u0005\u0000\u0001C\u0001\u0000\u0001C\u001d\u0000\u0001C\u0004\u0000\u0002D\u0004\u0000\u0006D\u0001\u0000\u0001D\u0007\u0000\u0003D\u0001\u0000\u0001D\u0007\u0000\u0001D\u0006\u0000\u0001D\u0004\u0000\u0001E\t\u0000\u0001E\"\u0000\u0002\"\u0001\u0000\u0001\"\u0003\u0000\u0002\"\u0001\u0000\u0001\"\u0001!\u0001\u0000\u0001#\b\u0000\u0001!\u0002\u0000\u0001#\u000e\u0000\u0001\"\u0004\u0000\u0002F\u0001\u0000\u0001F\u0003\u0000\u0002F\u0001\u0000\u0001F\u0003\u0000\u0001G\u0014\u0000\u0001G\u0004\u0000\u0001F\u0004\u0000\u0002H\u0001$\u0001H\u0003\u0000\u0002H\u0001\u0000\u0001H\u001d\u0000\u0001H\u0015\u0000\u0001I/\u0000\u0001J)\u0000\u0001K.\u0000\u0001L6\u0000\u0001M\u001f\u0000\u0001N6\u0000\u0001O\u0012\u0000\u0001-\u0007\u0000\u0001-\u0001\u0000\u0001-\u001d\u0000\u0001-\u0004\u0000\u0001P\u0007\u0000\u0001P\u0001\u0000\u0001P\u001d\u0000\u0001P\u0004\u0000\u0002Q\u0004\u0000\u0006Q\u0001\u0000\u0001Q\u0007\u0000\u0003Q\u0001\u0000\u0001Q\u0007\u0000\u0001Q\u0006\u0000\u0001Q\u0004\u0000\u0001R\u0007\u0000\u0001R\u0001\u0000\u0001R\u0019\u0000\u0001S\u0003\u0000\u0001R\u0004\u0000\u00018\u0007\u0000\u00018\u0001\u0000\u00018\u0019\u0000\u0001S\u0003\u0000\u00018(\u0000\u0001T\b\u0000\u0002U\u0004\u0000\u0006U\u0001\u0000\u0001U\u0007\u0000\u0003U\u0001\u0000\u0001U\u0007\u0000\u0001U\u0006\u0000\u0001U(\u0000\u0001V,\u0000\u0001W,\u0000\u0001X,\u0000\u0001Y,\u0000\u0001Z,\u0000\u0001[\b\u0000\u0001C\u0001\u0000\u0001\u001d\u0001\u0000\u0001B\u0003\u0000\u0001C\u0001\u0000\u0001C\u0006\u0000\u0001B\u0016\u0000\u0001C\u0004\u0000\u0002D\u0001\\\u0001\u0000\u0001]\u0001\u0000\u0006D\u0001\u0000\u0001D\u0003\u0000\u0001]\u0003\u0000\u0003D\u0001\u0000\u0001D\u0007\u0000\u0001D\u0006\u0000\u0001D\u0004\u0000\u0001E\u0001\u0000\u0001^\u0001\u0000\u0001_\u0005\u0000\u0001E\u0006\u0000\u0001_\u001b\u0000\u0002F\u0001\u0000\u0001F\u0003\u0000\u0002F\u0001\u0000\u0001F\u0001!\n\u0000\u0001!\u0011\u0000\u0001F\u0004\u0000\u0002F\u0001\u0000\u0001F\u0003\u0000\u0002F\u0001\u0000\u0001F\u001d\u0000\u0001F\u0004\u0000\u0002H\u0001$\u0001H\u0001\u001e\u0002\u0000\u0002H\u0001\u0000\u0001H\u0006\u0000\u0001\u001e\u0016\u0000\u0001H\u0015\u0000\u0001`0\u0000\u0001a/\u0000\u0001b/\u0000\u0001c+\u0000\u0001d+\u0000\u0001e,\u0000\u0001f\u0013\u0000\u0002g\u0004\u0000\u0006g\u0001\u0000\u0001g\u0007\u0000\u0003g\u0001\u0000\u0001g\u0007\u0000\u0001g\u0006\u0000\u0001g(\u0000\u0001S\b\u0000\u0002h\u0004\u0000\u0006h\u0001\u0000\u0001h\u0007\u0000\u0003h\u0001\u0000\u0001h\u0007\u0000\u0001h\u0006\u0000\u0001h\u0004\u0000\u0002D\u0001\\\u0003\u0000\u0006D\u0001\u0000\u0001D\u0007\u0000\u0003D\u0001\u0000\u0001D\u0007\u0000\u0001D\u0006\u0000\u0001D\u0004\u0000\u0001E\u0001\u0000\u0001^\u0007\u0000\u0001E;\u0000\u0001i-\u0000\u0001j0\u0000\u0001k\u000e\u0000\u0002l\u0004\u0000\u0006l\u0001\u0000\u0001l\u0007\u0000\u0003l\u0001\u0000\u0001l\u0007\u0000\u0001l\u0006\u0000\u0001l\u0004\u0000\u0002m\u0004\u0000\u0006m\u0001\u0000\u0001m\u0007\u0000\u0003m\u0001\u0000\u0001m\u0007\u0000\u0001m\u0006\u0000\u0001m\u0004\u0000\u0002n\u0004\u0000\u0006n\u0001\u0000\u0001n\u0007\u0000\u0003n\u0001\u0000\u0001n\u0007\u0000\u0001n\u0006\u0000\u0001n\u0004\u0000\u0002o\u0004\u0000\u0006o\u0001\u0000\u0001o\u0007\u0000\u0003o\u0001\u0000\u0001o\u0007\u0000\u0001o\u0006\u0000\u0001o(\u0000\u0001p\u0007\u0000";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = OperatorLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\t\n\u0001\u0002\t\u0001\u0001\u0003\t\u0002\u0001\u0001\t\u0003\u0001\u0001\u0000\u0001\u0001\u0001\u0000\u0001\t\u0002\u0000\u0001\t\u0001\u0001\t\u0000\u0002\u0001\u0001\t\u0001\u0000\b\t\n\u0000\u0001\t\u0004\u0001\u0001\u0000\u0001\u0001\u0007\u0000\u0001\t\u0002\u0000\u0002\t\u0001\u0000\u0006\t\u0001\u0000\u0001\t\u0001\u0000\u0003\t\u0003\u0000\u0002\t\u0002\u0000\u0003\t\u0002\u0000\u0001\t\u0001\u0000\u0001\t";
    private Reader zzReader;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer = new char[16384];
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    private StringBuffer string = new StringBuffer();

    private static int[] zzUnpackAction() {
        int[] result = new int[112];
        int offset = 0;
        offset = OperatorLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[112];
        int offset = 0;
        offset = OperatorLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int high = packed.charAt(i2++) << 16;
            result[j++] = high | packed.charAt(i2++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3285];
        int offset = 0;
        offset = OperatorLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            int value = packed.charAt(i2++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[112];
        int offset = 0;
        offset = OperatorLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i2 = 0;
        int j = offset;
        int l = packed.length();
        while (i2 < l) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private void error(String message) {
        String fullMessage = String.format("%1$s %1$s at %2$d:%3$d", message, this.yyline, this.yycolumn);
        throw new RuntimeException(fullMessage);
    }

    private Token charLiteral() {
        return this.charLiteral(this.yycharat(0));
    }

    private Token charLiteral(char value) {
        this.yybegin(0);
        return new Token(TokenType.CHAR_LITERAL, Character.valueOf(value));
    }

    private String slice(int start, int end) {
        return this.yytext().subSequence(start, this.yylength() + end).toString();
    }

    private char fromOctal() {
        return this.fromOctal(this.yytext().subSequence(1, this.yylength()).toString());
    }

    private char fromOctal(String value) {
        return (char)Integer.parseInt(value, 8);
    }

    private char fromHex(String value) {
        return (char)Integer.parseInt(value, 16);
    }

    private char fromHex() {
        return (char)Integer.parseInt(this.yytext().subSequence(2, this.yylength()).toString(), 16);
    }

    private Token parse(Literal literal, Base system) {
        String lexeme = new String(this.zzBuffer, this.zzStartRead + system.start, this.yylength() - (system.start + literal.end));
        Number value = Converter.valueOf(literal.type, lexeme, system.ten);
        return this.tokenOrError(value, literal.token, lexeme);
    }

    private Token parse(Literal literal) {
        String lexeme = new String(this.zzBuffer, this.zzStartRead, this.yylength() - literal.end);
        Number value = Converter.valueOf(literal.type, lexeme);
        return this.tokenOrError(value, literal.token, lexeme);
    }

    private Token tokenOrError(Object value, TokenType token, String lexeme) {
        if (value == null) {
            this.error("Invalid literal: " + lexeme);
        }
        return new Token(token, value);
    }

    OperatorLexer(Reader in) {
        this.zzReader = in;
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i2 = 0;
        int j = 0;
        while (i2 < 374) {
            int count = packed.charAt(i2++);
            char value = packed.charAt(i2++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    private boolean zzRefill() throws IOException {
        int requested;
        int numRead;
        if (this.zzStartRead > 0) {
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
            System.arraycopy(this.zzBuffer, this.zzStartRead, this.zzBuffer, 0, this.zzEndRead - this.zzStartRead);
            this.zzEndRead -= this.zzStartRead;
            this.zzCurrentPos -= this.zzStartRead;
            this.zzMarkedPos -= this.zzStartRead;
            this.zzStartRead = 0;
        }
        if (this.zzCurrentPos >= this.zzBuffer.length - this.zzFinalHighSurrogate) {
            char[] newBuffer = new char[this.zzBuffer.length * 2];
            System.arraycopy(this.zzBuffer, 0, newBuffer, 0, this.zzBuffer.length);
            this.zzBuffer = newBuffer;
            this.zzEndRead += this.zzFinalHighSurrogate;
            this.zzFinalHighSurrogate = 0;
        }
        if ((numRead = this.zzReader.read(this.zzBuffer, this.zzEndRead, requested = this.zzBuffer.length - this.zzEndRead)) == 0) {
            throw new IOException("Reader returned 0 characters. See JFlex examples for workaround.");
        }
        if (numRead > 0) {
            this.zzEndRead += numRead;
            if (numRead == requested && Character.isHighSurrogate(this.zzBuffer[this.zzEndRead - 1])) {
                --this.zzEndRead;
                this.zzFinalHighSurrogate = 1;
            }
            return false;
        }
        return true;
    }

    public final void yyclose() throws IOException {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
        if (this.zzReader != null) {
            this.zzReader.close();
        }
    }

    public final void yyreset(Reader reader) {
        this.zzReader = reader;
        this.zzAtBOL = true;
        this.zzAtEOF = false;
        this.zzEOFDone = false;
        this.zzStartRead = 0;
        this.zzEndRead = 0;
        this.zzMarkedPos = 0;
        this.zzCurrentPos = 0;
        this.zzFinalHighSurrogate = 0;
        this.yycolumn = 0;
        this.yychar = 0;
        this.yyline = 0;
        this.zzLexicalState = 0;
        if (this.zzBuffer.length > 16384) {
            this.zzBuffer = new char[16384];
        }
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    public Token nextToken() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block98: while (true) {
            int zzInput;
            boolean eof;
            int zzCurrentPosL;
            int zzCharCount;
            int zzMarkedPosL = this.zzMarkedPos;
            boolean zzR = false;
            block99: for (zzCurrentPosL = this.zzStartRead; zzCurrentPosL < zzMarkedPosL; zzCurrentPosL += zzCharCount) {
                int zzCh = Character.codePointAt(zzBufferL, zzCurrentPosL, zzMarkedPosL);
                zzCharCount = Character.charCount(zzCh);
                switch (zzCh) {
                    case 11: 
                    case 12: 
                    case 133: 
                    case 8232: 
                    case 8233: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = false;
                        continue block99;
                    }
                    case 13: {
                        ++this.yyline;
                        this.yycolumn = 0;
                        zzR = true;
                        continue block99;
                    }
                    case 10: {
                        if (zzR) {
                            zzR = false;
                            continue block99;
                        }
                        ++this.yyline;
                        this.yycolumn = 0;
                        continue block99;
                    }
                    default: {
                        zzR = false;
                        this.yycolumn += zzCharCount;
                    }
                }
            }
            if (zzR) {
                boolean zzPeek;
                if (zzMarkedPosL < zzEndReadL) {
                    zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                } else if (this.zzAtEOF) {
                    zzPeek = false;
                } else {
                    eof = this.zzRefill();
                    zzEndReadL = this.zzEndRead;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    if (eof) {
                        zzPeek = false;
                    } else {
                        boolean bl = zzPeek = zzBufferL[zzMarkedPosL] == '\n';
                    }
                }
                if (zzPeek) {
                    --this.yyline;
                }
            }
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                return Token.EOF;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.error("Illegal character + <" + this.yytext() + ">");
                }
                case 47: {
                    continue block98;
                }
                case 2: {
                    return this.parse(Literal.INT);
                }
                case 48: {
                    continue block98;
                }
                case 3: {
                    return this.parse(Literal.DOUBLE);
                }
                case 49: {
                    continue block98;
                }
                case 4: {
                    return Token.LPAR;
                }
                case 50: {
                    continue block98;
                }
                case 5: {
                    return Token.RPAR;
                }
                case 51: {
                    continue block98;
                }
                case 6: {
                    return Token.MINUS;
                }
                case 52: {
                    continue block98;
                }
                case 7: {
                    this.yybegin(4);
                }
                case 53: {
                    continue block98;
                }
                case 8: {
                    this.yybegin(2);
                    this.string.setLength(0);
                }
                case 54: {
                    continue block98;
                }
                case 9: 
                case 55: {
                    continue block98;
                }
                case 10: {
                    this.string.append(this.yytext());
                }
                case 56: {
                    continue block98;
                }
                case 11: {
                    this.yybegin(0);
                    return new Token(TokenType.STRING_LITERAL, this.string.toString());
                }
                case 57: {
                    continue block98;
                }
                case 12: {
                    return this.parse(Literal.INT, Base.OCTAL);
                }
                case 58: {
                    continue block98;
                }
                case 13: {
                    return this.parse(Literal.LONG);
                }
                case 59: {
                    continue block98;
                }
                case 14: {
                    return this.parse(Literal.FLOAT);
                }
                case 60: {
                    continue block98;
                }
                case 15: {
                    this.string.append(this.fromOctal());
                }
                case 61: {
                    continue block98;
                }
                case 16: {
                    this.string.append('\n');
                }
                case 62: {
                    continue block98;
                }
                case 17: {
                    this.string.append('\f');
                }
                case 63: {
                    continue block98;
                }
                case 18: {
                    this.string.append('\t');
                }
                case 64: {
                    continue block98;
                }
                case 19: {
                    this.string.append('\r');
                }
                case 65: {
                    continue block98;
                }
                case 20: {
                    this.string.append('\b');
                }
                case 66: {
                    continue block98;
                }
                case 21: {
                    this.string.append('\'');
                }
                case 67: {
                    continue block98;
                }
                case 22: {
                    this.string.append('\"');
                }
                case 68: {
                    continue block98;
                }
                case 23: {
                    this.string.append('\\');
                }
                case 69: {
                    continue block98;
                }
                case 24: {
                    return this.charLiteral();
                }
                case 70: {
                    continue block98;
                }
                case 25: {
                    return this.parse(Literal.LONG, Base.OCTAL);
                }
                case 71: {
                    continue block98;
                }
                case 26: {
                    return this.parse(Literal.INT, Base.HEXADECIMAL);
                }
                case 72: {
                    continue block98;
                }
                case 27: {
                    return this.parse(Literal.INT, Base.BINARY);
                }
                case 73: {
                    continue block98;
                }
                case 28: {
                    return this.charLiteral(this.fromOctal(this.slice(1, -1)));
                }
                case 74: {
                    continue block98;
                }
                case 29: {
                    return this.charLiteral('\n');
                }
                case 75: {
                    continue block98;
                }
                case 30: {
                    return this.charLiteral('\f');
                }
                case 76: {
                    continue block98;
                }
                case 31: {
                    return this.charLiteral('\t');
                }
                case 77: {
                    continue block98;
                }
                case 32: {
                    return this.charLiteral('\r');
                }
                case 78: {
                    continue block98;
                }
                case 33: {
                    return this.charLiteral('\b');
                }
                case 79: {
                    continue block98;
                }
                case 34: {
                    return this.charLiteral('\'');
                }
                case 80: {
                    continue block98;
                }
                case 35: {
                    return this.charLiteral('\\');
                }
                case 81: {
                    continue block98;
                }
                case 36: {
                    return this.parse(Literal.LONG, Base.HEXADECIMAL);
                }
                case 82: {
                    continue block98;
                }
                case 37: {
                    return this.parse(Literal.LONG, Base.BINARY);
                }
                case 83: {
                    continue block98;
                }
                case 38: {
                    return Token.NULL;
                }
                case 84: {
                    continue block98;
                }
                case 39: {
                    return Token.VOID;
                }
                case 85: {
                    continue block98;
                }
                case 40: {
                    return Token.TRUE;
                }
                case 86: {
                    continue block98;
                }
                case 41: {
                    return Token.BYTE;
                }
                case 87: {
                    continue block98;
                }
                case 42: {
                    return Token.FALSE;
                }
                case 88: {
                    continue block98;
                }
                case 43: {
                    return Token.SHORT;
                }
                case 89: {
                    continue block98;
                }
                case 44: {
                    return Token.EMPTY;
                }
                case 90: {
                    continue block98;
                }
                case 45: {
                    this.string.append(this.fromHex());
                }
                case 91: {
                    continue block98;
                }
                case 46: {
                    return this.charLiteral(this.fromHex(this.slice(2, -1)));
                }
                case 92: {
                    continue block98;
                }
            }
            this.zzScanError(1);
        }
    }

    private static enum Base {
        BINARY(2, 2),
        OCTAL(8, 1),
        DECIMAL(10, 0),
        HEXADECIMAL(16, 2);

        int ten;
        int start;

        private Base(int ten, int start) {
            this.ten = ten;
            this.start = start;
        }
    }

    private static enum Literal {
        INT(TokenType.INT_LITERAL, Integer.class, 0),
        LONG(TokenType.LONG_LITERAL, Long.class, 1),
        FLOAT(TokenType.FLOAT_LITERAL, Float.class, 1),
        DOUBLE(TokenType.DOUBLE_LITERAL, Double.class, 0);

        TokenType token;
        Class<? extends Number> type;
        int end;

        private Literal(TokenType token, Class<? extends Number> type, int end) {
            this.token = token;
            this.type = type;
            this.end = end;
        }
    }
}

