/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.mutationtest.descartes.stopmethods;

import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodInterceptor;
import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodMatcher;
import eu.stamp_project.mutationtest.descartes.stopmethods.StopMethodMatchers;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.pitest.mutationtest.build.InterceptorParameters;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.MutationInterceptorFactory;
import org.pitest.plugin.Feature;
import org.pitest.plugin.FeatureParameter;

public class StopMethodMatcherInterceptorFactory
implements MutationInterceptorFactory {
    private FeatureParameter EXCEPT = FeatureParameter.named("except");
    private Map<String, StopMethodMatcher> availabeMatchers = new HashMap<String, StopMethodMatcher>();

    public StopMethodMatcherInterceptorFactory() {
        this.availabeMatchers.put("empty", StopMethodMatchers.isEmptyVoid());
        this.availabeMatchers.put("enum", StopMethodMatchers.isEnumGenerated());
        this.availabeMatchers.put("to_string", StopMethodMatchers.isToString());
        this.availabeMatchers.put("hash_code", StopMethodMatchers.isHashCode());
        this.availabeMatchers.put("deprecated", StopMethodMatchers.isDeprecated());
        this.availabeMatchers.put("synthetic", StopMethodMatchers.isSynthetic());
        this.availabeMatchers.put("getter", StopMethodMatchers.isSimpleGetter());
        this.availabeMatchers.put("setter", StopMethodMatchers.isSimpleSetter());
        this.availabeMatchers.put("constant", StopMethodMatchers.returnsAConstant());
        this.availabeMatchers.put("delegate", StopMethodMatchers.isDelegate());
        this.availabeMatchers.put("clinit", StopMethodMatchers.isStaticInitializer());
        this.availabeMatchers.put("empty_array", StopMethodMatchers.returnsAnEmptyArray());
        String description = "Allows to reinsert some stop methods to the analysis. Possible values are: ";
        description = description + this.availabeMatchers.keySet().stream().collect(Collectors.joining(", "));
        this.EXCEPT.withDescription(description);
    }

    @Override
    public MutationInterceptor createInterceptor(InterceptorParameters interceptorParameters) {
        Set<String> matchers = this.availabeMatchers.keySet();
        List<String> exclusions = interceptorParameters.getList(this.EXCEPT);
        if (exclusions != null) {
            matchers.removeAll(exclusions);
        }
        return new StopMethodInterceptor(StopMethodMatcher.any(matchers.stream().map(key -> this.availabeMatchers.get(key)).collect(Collectors.toList())));
    }

    @Override
    public Feature provides() {
        return Feature.named("STOP_METHODS").withOnByDefault(true).withDescription("Removes mutations in methods which are of no interest").withParameter(this.EXCEPT);
    }

    @Override
    public String description() {
        return "Removes mutation in methods which are of no interest";
    }
}

