/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.reloc.utils;

import eu.stamp_project.reloc.utils.CSSMin;
import eu.stamp_project.reloc.utils.EmptySelectorBodyException;
import eu.stamp_project.reloc.utils.IncompletePropertyException;
import eu.stamp_project.reloc.utils.IncompleteSelectorException;
import eu.stamp_project.reloc.utils.Property;
import eu.stamp_project.reloc.utils.UnterminatedSelectorException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import java.util.logging.Logger;

class Selector {
    private static final Logger LOG = Logger.getLogger(Selector.class.getName());
    private Property[] properties = null;
    private Vector<Selector> subSelectors = null;
    private String selector;

    Selector(String selector) throws IncompleteSelectorException, UnterminatedSelectorException, EmptySelectorBodyException {
        String[] parts = selector.split("\\{");
        if (parts.length < 2) {
            throw new IncompleteSelectorException(selector);
        }
        this.selector = parts[0].trim();
        this.selector = this.selector.replaceAll("\\s?(\\+|~|,|=|~=|\\^=|\\$=|\\*=|\\|=|>)\\s?", "$1");
        if (parts.length > 2) {
            this.subSelectors = new Vector();
            parts = selector.split("(\\s*\\{\\s*)|(\\s*\\}\\s*)");
            for (int i2 = 1; i2 < parts.length; i2 += 2) {
                parts[i2] = parts[i2].trim();
                parts[i2 + 1] = parts[i2 + 1].trim();
                if (parts[i2].equals("") || parts[i2 + 1].equals("")) continue;
                this.subSelectors.addElement(new Selector(parts[i2] + "{" + parts[i2 + 1] + "}"));
            }
        } else {
            String contents = parts[parts.length - 1].trim();
            if (CSSMin.debugLogging) {
                LOG.info("Parsing selector: " + this.selector);
                LOG.info("\t" + contents);
            }
            if (contents.charAt(contents.length() - 1) != '}') {
                throw new UnterminatedSelectorException(selector);
            }
            if (contents.length() == 1) {
                throw new EmptySelectorBodyException(selector);
            }
            int endIndex = contents.endsWith(";}") ? 2 : 1;
            contents = contents.substring(0, contents.length() - endIndex);
            this.properties = new Property[0];
            this.properties = this.parseProperties(contents).toArray(this.properties);
            this.sortProperties(this.properties);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.selector).append("{");
        if (this.subSelectors != null) {
            for (Selector s : this.subSelectors) {
                sb.append(s.toString());
            }
        }
        if (this.properties != null) {
            for (Property p : this.properties) {
                sb.append(p.toString());
            }
        }
        if (sb.charAt(sb.length() - 1) == ';') {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    private ArrayList<Property> parseProperties(String contents) {
        String substr;
        ArrayList<String> parts = new ArrayList<String>();
        boolean bInsideString = false;
        boolean bInsideURL = false;
        int j = 0;
        for (int i2 = 0; i2 < contents.length(); ++i2) {
            if (bInsideString) {
                bInsideString = contents.charAt(i2) != '\"';
                continue;
            }
            if (bInsideURL) {
                bInsideURL = contents.charAt(i2) != ')';
                continue;
            }
            if (contents.charAt(i2) == '\"') {
                bInsideString = true;
                continue;
            }
            if (contents.charAt(i2) == '(') {
                if (i2 - 3 <= 0 || !"url".equals(contents.substring(i2 - 3, i2))) continue;
                bInsideURL = true;
                continue;
            }
            if (contents.charAt(i2) != ';') continue;
            substr = contents.substring(j, i2);
            if (!substr.trim().equals("")) {
                parts.add(substr);
            }
            j = i2 + 1;
        }
        substr = contents.substring(j, contents.length());
        if (!substr.trim().equals("")) {
            parts.add(substr);
        }
        ArrayList<Property> results = new ArrayList<Property>();
        for (String part : parts) {
            try {
                results.add(new Property(part));
            }
            catch (IncompletePropertyException ipex) {
                LOG.warning("Incomplete property in selector \"" + this.selector + "\": \"" + ipex.getMessage() + "\"");
            }
        }
        return results;
    }

    private void sortProperties(Property[] properties) {
        Arrays.sort(properties);
    }
}

