/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.listener.impl;

import eu.stamp_project.testrunner.listener.Coverage;
import eu.stamp_project.testrunner.listener.CoveragePerTestMethod;
import eu.stamp_project.testrunner.listener.CoverageTransformer;
import eu.stamp_project.testrunner.listener.utils.ListenerUtils;
import eu.stamp_project.testrunner.utils.ConstantsHelper;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jacoco.core.data.ExecutionDataStore;
import org.jacoco.core.data.SessionInfoStore;
import org.jacoco.core.runtime.RuntimeData;

public class CoveragePerTestMethodImpl
implements CoveragePerTestMethod {
    private static final long serialVersionUID = 606642107403361456L;
    protected final transient Map<String, ExecutionDataStore> executionDataStoreMap;
    protected final ConcurrentHashMap<String, Coverage> coverageResultsMap;
    protected final List<String> classesDirectory;
    protected transient RuntimeData data;
    protected transient ExecutionDataStore executionData;
    protected transient SessionInfoStore sessionInfos;
    protected transient CoverageTransformer coverageTransformer;

    public CoveragePerTestMethodImpl(RuntimeData data, List<String> classesDirectory, CoverageTransformer coverageTransformer) {
        this.data = data;
        this.classesDirectory = classesDirectory;
        this.executionDataStoreMap = new HashMap<String, ExecutionDataStore>();
        this.coverageResultsMap = new ConcurrentHashMap();
        this.coverageTransformer = coverageTransformer;
    }

    public List<String> getClassesDirectory() {
        return this.classesDirectory;
    }

    public RuntimeData getData() {
        return this.data;
    }

    public ExecutionDataStore getExecutionData() {
        return this.executionData;
    }

    public SessionInfoStore getSessionInfos() {
        return this.sessionInfos;
    }

    public CoverageTransformer getCoverageTransformer() {
        return this.coverageTransformer;
    }

    public void setData(RuntimeData data) {
        this.data = data;
    }

    public void setExecutionData(ExecutionDataStore executionData) {
        this.executionData = executionData;
    }

    public void setSessionInfos(SessionInfoStore sessionInfos) {
        this.sessionInfos = sessionInfos;
    }

    public Map<String, ExecutionDataStore> getExecutionDataStoreMap() {
        return this.executionDataStoreMap;
    }

    @Override
    public void computeCoverages() {
        this.executionDataStoreMap.entrySet().parallelStream().forEach(x -> {
            Coverage jUnit4Coverage = this.coverageTransformer.transformJacocoObject((ExecutionDataStore)x.getValue(), this.classesDirectory);
            this.coverageResultsMap.put((String)x.getKey(), jUnit4Coverage);
        });
    }

    @Override
    public Map<String, Coverage> getCoverageResultsMap() {
        return this.coverageResultsMap;
    }

    @Override
    public Coverage getCoverageOf(String testMethodName) {
        return this.getCoverageResultsMap().get(testMethodName);
    }

    @Override
    public void save() {
        ListenerUtils.saveToMemoryMappedFile(new File(OUTPUT_DIR, "CoveragePerTestMethod.dat"), this);
    }

    public static CoveragePerTestMethodImpl load() {
        return (CoveragePerTestMethodImpl)ListenerUtils.loadFromMemoryMappedFile(ListenerUtils.computeTargetFilePath(OUTPUT_DIR, "CoveragePerTestMethod.dat"));
    }

    public String toString() {
        return this.coverageResultsMap.keySet().stream().map(test -> "\t" + test + ": " + this.coverageResultsMap.get(test).toString()).collect(Collectors.joining(ConstantsHelper.LINE_SEPARATOR));
    }
}

