/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.runner.coverage;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashMap;
import java.util.Map;

public class MemoryClassLoader
extends URLClassLoader {
    private Map<String, byte[]> definitions = new HashMap<String, byte[]>();

    public MemoryClassLoader(URL[] urls) {
        super(urls, ClassLoader.getSystemClassLoader());
    }

    public MemoryClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    public void addDefinition(String name, byte[] bytes) {
        this.definitions.put(name, bytes);
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        byte[] bytes = this.definitions.get(name);
        try {
            if (bytes != null) {
                return this.defineClass(name, bytes, 0, bytes.length);
            }
        }
        catch (LinkageError error) {
            return super.loadClass(name, false);
        }
        return super.loadClass(name, false);
    }

    public Map<String, byte[]> getDefinitions() {
        return this.definitions;
    }

    public void setDefinitions(Map<String, byte[]> definitions) {
        this.definitions = definitions;
    }
}

