/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.testrunner.test_framework;

import eu.stamp_project.testrunner.runner.Failure;
import eu.stamp_project.testrunner.test_framework.AbstractTestFrameworkDecorator;
import eu.stamp_project.testrunner.test_framework.TestFrameworkSupport;
import eu.stamp_project.testrunner.test_framework.assertions.AssertEnum;
import eu.stamp_project.testrunner.test_framework.implementations.AssertJTestFramework;
import eu.stamp_project.testrunner.test_framework.implementations.GoogleTruthTestFramework;
import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnit3Support;
import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnit4Support;
import eu.stamp_project.testrunner.test_framework.implementations.junit.JUnit5Support;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spoon.reflect.code.CtExpression;
import spoon.reflect.code.CtInvocation;
import spoon.reflect.code.CtStatement;
import spoon.reflect.declaration.CtElement;
import spoon.reflect.declaration.CtMethod;
import spoon.reflect.declaration.CtType;
import spoon.reflect.declaration.CtTypeInformation;
import spoon.reflect.factory.Factory;
import spoon.reflect.visitor.filter.TypeFilter;

public class TestFramework
implements TestFrameworkSupport {
    private static final Logger LOGGER = LoggerFactory.getLogger(TestFramework.class);
    private static TestFramework _instance;
    private HashMap<CtMethod<?>, TestFrameworkSupport> cachedTestFrameworks;
    private List<TestFrameworkSupport> testFrameworkSupportList;
    private Factory factory;
    public static final TypeFilter<CtInvocation<?>> ASSERTIONS_FILTER;

    public static void init(Factory factory) {
        _instance = new TestFramework(factory);
    }

    public static TestFramework get() {
        return _instance;
    }

    private TestFramework(Factory factory) {
        this.factory = factory;
        this.cachedTestFrameworks = new HashMap();
        this.testFrameworkSupportList = new ArrayList<TestFrameworkSupport>();
        this.testFrameworkSupportList.add(new JUnit3Support());
        this.testFrameworkSupportList.add(new JUnit4Support());
        this.testFrameworkSupportList.add(new JUnit5Support());
        this.testFrameworkSupportList.add(new GoogleTruthTestFramework());
        this.testFrameworkSupportList.add(new AssertJTestFramework());
    }

    public static boolean isJUnit5(CtMethod<?> ctMethod) {
        return TestFramework.get().getTestFramework(ctMethod) instanceof JUnit5Support;
    }

    public static boolean isJUnit4(CtMethod<?> ctMethod) {
        return TestFramework.get().getTestFramework(ctMethod) instanceof JUnit3Support || TestFramework.get().getTestFramework(ctMethod) instanceof JUnit4Support;
    }

    @Override
    public boolean isIgnored(CtElement candidate) {
        for (TestFrameworkSupport testFrameworkSupport : this.testFrameworkSupportList) {
            if (!testFrameworkSupport.isIgnored(candidate)) continue;
            candidate.putMetadata(this.getKeyOfTestFramework(testFrameworkSupport), Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssert(CtInvocation<?> invocation) {
        for (TestFrameworkSupport testFrameworkSupport : this.testFrameworkSupportList) {
            if (!testFrameworkSupport.isAssert(invocation)) continue;
            invocation.putMetadata(this.getKeyOfTestFramework(testFrameworkSupport), Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssert(CtStatement candidate) {
        if (candidate instanceof CtInvocation) {
            return this.isAssert((CtInvocation)candidate);
        }
        return false;
    }

    @Override
    public boolean isInAssert(CtElement candidate) {
        if (candidate.getParent(CtInvocation.class) != null) {
            return this.isAssert(candidate.getParent(CtInvocation.class));
        }
        return false;
    }

    @Override
    public boolean isTest(CtMethod<?> candidate) {
        for (TestFrameworkSupport testFrameworkSupport : this.testFrameworkSupportList) {
            if (!testFrameworkSupport.isTest(candidate)) continue;
            candidate.putMetadata(this.getKeyOfTestFramework(testFrameworkSupport), Boolean.TRUE.toString());
            return true;
        }
        return false;
    }

    public String getKeyOfTestFramework(TestFrameworkSupport testFrameworkSupport) {
        return testFrameworkSupport.getClass().getSimpleName();
    }

    private TestFrameworkSupport getTestFramework(CtMethod<?> testMethod) {
        if (!this.cachedTestFrameworks.containsKey(testMethod)) {
            this.cachedTestFrameworks.put(testMethod, this.getTestFrameworkImpl(testMethod));
        }
        return this.cachedTestFrameworks.get(testMethod);
    }

    private TestFrameworkSupport getTestFrameworkImpl(CtMethod<?> testMethod) {
        TestFrameworkSupport testFrameworkSupport2;
        Map numberOfCallsToAssertionPerTestFramework = this.testFrameworkSupportList.stream().collect(Collectors.toMap(Function.identity(), testFrameworkSupport -> testMethod.getElements(new TypeFilter<CtStatement>(CtStatement.class)).stream().filter(testFrameworkSupport::isAssert).count()));
        if (numberOfCallsToAssertionPerTestFramework.values().stream().allMatch(aLong -> aLong == 0L)) {
            TestFrameworkSupport testFrameworkSupport3 = this.getTestFrameworkSupportFromIsTest(testMethod);
            if (testFrameworkSupport3 != null) {
                return testFrameworkSupport3;
            }
            return this.testFrameworkSupportList.get(1);
        }
        TestFrameworkSupport selectedTestFramework = (TestFrameworkSupport)Collections.max(numberOfCallsToAssertionPerTestFramework.entrySet(), Map.Entry.comparingByValue()).getKey();
        if (selectedTestFramework instanceof AbstractTestFrameworkDecorator && (testFrameworkSupport2 = this.getTestFrameworkSupportFromIsTest(testMethod)) != null) {
            ((AbstractTestFrameworkDecorator)selectedTestFramework).setInnerTestFramework(testFrameworkSupport2);
        }
        return selectedTestFramework;
    }

    private TestFrameworkSupport getTestFrameworkSupportFromIsTest(CtMethod<?> testMethod) {
        for (TestFrameworkSupport testFrameworkSupport : this.testFrameworkSupportList) {
            if (!testFrameworkSupport.isTest(testMethod)) continue;
            return testFrameworkSupport;
        }
        return null;
    }

    @Override
    public CtInvocation<?> buildInvocationToAssertion(CtMethod<?> testMethod, AssertEnum assertEnum, List<CtExpression> arguments) {
        return this.getTestFramework(testMethod).buildInvocationToAssertion(testMethod, assertEnum, arguments);
    }

    public static Stream<CtType<?>> getAllTestClassesAsStream() {
        return TestFramework._instance.factory.Type().getAll().stream().filter(ctType -> ctType.getMethods().stream().anyMatch(TestFramework.get()::isTest));
    }

    public static List<CtType<?>> getAllTestClasses() {
        return TestFramework.getAllTestClassesAsStream().collect(Collectors.toList());
    }

    public static String[] getAllTestClassesName() {
        return (String[])TestFramework.getAllTestClassesAsStream().map(CtTypeInformation::getQualifiedName).toArray(String[]::new);
    }

    public static List<CtMethod<?>> getAllTest(CtType<?> classTest) {
        Set<CtMethod<?>> methods = classTest.getMethods();
        return methods.stream().filter(TestFramework.get()::isTest).distinct().collect(Collectors.toList());
    }

    @Override
    public CtMethod<?> prepareTestMethod(CtMethod<?> testMethod) {
        return this.getTestFramework(testMethod).prepareTestMethod(testMethod);
    }

    @Override
    public CtMethod<?> generateExpectedExceptionsBlock(CtMethod<?> test, Failure failure, int numberOfFail) {
        return this.getTestFramework(test).generateExpectedExceptionsBlock(test, failure, numberOfFail);
    }

    @Override
    public void generateAfterClassToSaveObservations(CtType<?> testClass, List<CtMethod<?>> testsToRun) {
        this.getTestFramework(testsToRun.get(0)).generateAfterClassToSaveObservations(testClass, testsToRun);
    }

    static {
        ASSERTIONS_FILTER = new TypeFilter<CtInvocation<?>>(CtInvocation.class){

            @Override
            public boolean matches(CtInvocation<?> element) {
                return TestFramework.get().isAssert(element);
            }
        };
    }
}

