/*
 * Decompiled with CFR 0.152.
 */
package eu.stamp_project.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class TypeHelper {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPER_MAP = new HashMap(16);
    private static final Map<Class<?>, Class<?>> WRAPPER_TO_PRIMITIVE_MAP = new HashMap(16);

    private TypeHelper() {
    }

    private static void add(Class<?> primitive, Class<?> wrapper) {
        PRIMITIVE_TO_WRAPPER_MAP.put(primitive, wrapper);
        WRAPPER_TO_PRIMITIVE_MAP.put(wrapper, primitive);
    }

    public static Set<Class<?>> getPrimitiveTypes() {
        return PRIMITIVE_TO_WRAPPER_MAP.keySet();
    }

    public static Set<Class<?>> getWrapperTypes() {
        return WRAPPER_TO_PRIMITIVE_MAP.keySet();
    }

    public static boolean isPrimitiveType(Class<?> type) {
        return type.isPrimitive();
    }

    public static boolean isWrapperType(Class<?> type) {
        return WRAPPER_TO_PRIMITIVE_MAP.containsKey(type);
    }

    public static boolean isConstantType(Class<?> type) {
        return !type.equals(Void.TYPE) && !type.equals(Void.class) && (type.isPrimitive() || TypeHelper.isWrapperType(type) || type.equals(String.class));
    }

    public static Class<?> wrap(Class<?> type) {
        if (type.isPrimitive()) {
            return PRIMITIVE_TO_WRAPPER_MAP.get(type);
        }
        return type;
    }

    public static Class<?> unwrap(Class<?> type) {
        if (TypeHelper.isWrapperType(type)) {
            return WRAPPER_TO_PRIMITIVE_MAP.get(type);
        }
        return type;
    }

    static {
        TypeHelper.add(Boolean.TYPE, Boolean.class);
        TypeHelper.add(Byte.TYPE, Byte.class);
        TypeHelper.add(Character.TYPE, Character.class);
        TypeHelper.add(Double.TYPE, Double.class);
        TypeHelper.add(Float.TYPE, Float.class);
        TypeHelper.add(Integer.TYPE, Integer.class);
        TypeHelper.add(Long.TYPE, Long.class);
        TypeHelper.add(Short.TYPE, Short.class);
        TypeHelper.add(Void.TYPE, Void.class);
    }
}

