/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ExportsStatement;
import org.eclipse.jdt.internal.compiler.ast.ModuleDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ModuleReference;
import org.eclipse.jdt.internal.compiler.ast.ModuleStatement;
import org.eclipse.jdt.internal.compiler.ast.OpensStatement;
import org.eclipse.jdt.internal.compiler.ast.ProvidesStatement;
import org.eclipse.jdt.internal.compiler.ast.RequiresStatement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.ast.UsesStatement;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.ISourceModule;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.AnnotatableInfo;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.MemberElementInfo;

public class ModuleDescriptionInfo
extends AnnotatableInfo
implements ISourceModule {
    protected static final char[][] NO_USES = new char[0][0];
    protected static final ModuleReferenceInfo[] NO_REQUIRES = new ModuleReferenceInfo[0];
    protected static final PackageExportInfo[] NO_EXPORTS = new PackageExportInfo[0];
    protected static final ServiceInfo[] NO_PROVIDES = new ServiceInfo[0];
    protected static final PackageExportInfo[] NO_OPENS = new PackageExportInfo[0];
    protected IJavaElement[] children = JavaElement.NO_ELEMENTS;
    ModuleReferenceInfo[] requires;
    PackageExportInfo[] exports;
    ServiceInfo[] services;
    PackageExportInfo[] opens;
    char[][] usedServices;
    IModuleDescription handle;
    char[] name;
    private Map<IJavaElement, String[]> categories;

    public static ModuleDescriptionInfo createModule(ModuleDeclaration module) {
        int i2;
        ModuleStatement[] refs;
        ModuleDescriptionInfo mod = new ModuleDescriptionInfo();
        mod.name = module.moduleName;
        mod.setFlags(module.modifiers);
        if (module.requiresCount > 0) {
            refs = module.requires;
            mod.requires = new ModuleReferenceInfo[refs.length + 1];
            mod.requires[0] = ModuleDescriptionInfo.getJavaBaseReference();
            i2 = 0;
            while (i2 < refs.length) {
                mod.requires[i2 + 1] = new ModuleReferenceInfo();
                mod.requires[i2 + 1].name = CharOperation.concatWith(((RequiresStatement)refs[i2]).module.tokens, '.');
                mod.requires[i2 + 1].modifiers = ((RequiresStatement)refs[i2]).modifiers;
                ++i2;
            }
        } else {
            ModuleReferenceInfo[] moduleReferenceInfoArray;
            if (CharOperation.equals(module.moduleName, TypeConstants.JAVA_BASE)) {
                moduleReferenceInfoArray = NO_REQUIRES;
            } else {
                ModuleReferenceInfo[] moduleReferenceInfoArray2 = new ModuleReferenceInfo[1];
                moduleReferenceInfoArray = moduleReferenceInfoArray2;
                moduleReferenceInfoArray2[0] = ModuleDescriptionInfo.getJavaBaseReference();
            }
            mod.requires = moduleReferenceInfoArray;
        }
        if (module.exportsCount > 0) {
            refs = module.exports;
            mod.exports = new PackageExportInfo[refs.length];
            i2 = 0;
            while (i2 < refs.length) {
                PackageExportInfo exp;
                mod.exports[i2] = exp = ModuleDescriptionInfo.createPackageExport((ExportsStatement)refs[i2]);
                ++i2;
            }
        } else {
            mod.exports = NO_EXPORTS;
        }
        if (module.usesCount > 0) {
            UsesStatement[] uses = module.uses;
            mod.usedServices = new char[uses.length][];
            i2 = 0;
            while (i2 < uses.length) {
                mod.usedServices[i2] = CharOperation.concatWith(uses[i2].serviceInterface.getTypeName(), '.');
                ++i2;
            }
        } else {
            mod.usedServices = NO_USES;
        }
        if (module.servicesCount > 0) {
            ProvidesStatement[] provides = module.services;
            mod.services = new ServiceInfo[provides.length];
            i2 = 0;
            while (i2 < provides.length) {
                mod.services[i2] = ModuleDescriptionInfo.createService(provides[i2]);
                ++i2;
            }
        } else {
            mod.services = NO_PROVIDES;
        }
        if (module.opensCount > 0) {
            OpensStatement[] opens = module.opens;
            mod.opens = new PackageExportInfo[opens.length];
            i2 = 0;
            while (i2 < opens.length) {
                PackageExportInfo op;
                mod.opens[i2] = op = ModuleDescriptionInfo.createOpensInfo(opens[i2]);
                ++i2;
            }
        } else {
            mod.opens = NO_OPENS;
        }
        return mod;
    }

    private static ModuleReferenceInfo getJavaBaseReference() {
        ModuleReferenceInfo ref = new ModuleReferenceInfo();
        ref.name = TypeConstants.JAVA_BASE;
        return ref;
    }

    private static PackageExportInfo createPackageExport(ExportsStatement ref) {
        PackageExportInfo exp = new PackageExportInfo();
        exp.pack = ref.pkgName;
        ModuleReference[] imp = ref.targets;
        if (imp != null) {
            exp.target = new char[imp.length][];
            int j = 0;
            while (j < imp.length) {
                exp.target[j] = imp[j].moduleName;
                ++j;
            }
        }
        return exp;
    }

    private static PackageExportInfo createOpensInfo(OpensStatement opens) {
        PackageExportInfo open = new PackageExportInfo();
        open.pack = opens.pkgName;
        ModuleReference[] imp = opens.targets;
        if (imp != null) {
            open.target = new char[imp.length][];
            int j = 0;
            while (j < imp.length) {
                open.target[j] = imp[j].moduleName;
                ++j;
            }
        }
        return open;
    }

    private static ServiceInfo createService(ProvidesStatement provides) {
        ServiceInfo info = new ServiceInfo();
        info.serviceName = CharOperation.concatWith(provides.serviceInterface.getTypeName(), '.');
        TypeReference[] implementations = provides.implementations;
        info.implNames = new char[implementations.length][];
        int i2 = 0;
        while (i2 < implementations.length) {
            info.implNames[i2] = CharOperation.concatWith(implementations[i2].getTypeName(), '.');
            ++i2;
        }
        return info;
    }

    protected void setHandle(IModuleDescription handle) {
        this.handle = handle;
    }

    public IModuleDescription getHandle() {
        return this.handle;
    }

    @Override
    public IJavaElement[] getChildren() {
        return this.children;
    }

    @Override
    public ICompilationUnit getCompilationUnit() {
        IJavaElement parent = this.handle.getParent();
        if (parent instanceof CompilationUnit) {
            return (CompilationUnit)parent;
        }
        return null;
    }

    @Override
    public boolean isOpen() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public char[] name() {
        return this.name;
    }

    @Override
    public IModule.IModuleReference[] requires() {
        return this.requires;
    }

    @Override
    public IModule.IPackageExport[] exports() {
        return this.exports;
    }

    @Override
    public char[][] uses() {
        return this.usedServices;
    }

    @Override
    public IModule.IService[] provides() {
        return this.services;
    }

    @Override
    public IModule.IPackageExport[] opens() {
        return this.opens;
    }

    public void addCategories(IJavaElement element, char[][] elementCategories) {
        if (elementCategories == null) {
            return;
        }
        if (this.categories == null) {
            this.categories = new HashMap<IJavaElement, String[]>();
        }
        this.categories.put(element, CharOperation.toStrings(elementCategories));
    }

    public Map<IJavaElement, String[]> getCategories() {
        return this.categories;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.getClass().getName());
        this.toStringContent(buffer);
        return buffer.toString();
    }

    protected void toStringContent(StringBuffer buffer) {
        int i2;
        buffer.append("\n");
        if (this.isOpen()) {
            buffer.append("open ");
        }
        buffer.append("module ");
        buffer.append(this.name).append(' ');
        buffer.append('{').append('\n');
        if (this.requires != null && this.requires.length > 0) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.requires.length) {
                buffer.append("\trequires ");
                if (this.requires[i2].isTransitive()) {
                    buffer.append("transitive ");
                }
                if (this.requires[i2].isStatic()) {
                    buffer.append("static ");
                }
                buffer.append(this.requires[i2].name);
                buffer.append(';').append('\n');
                ++i2;
            }
        }
        if (this.exports != null && this.exports.length > 0) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.exports.length) {
                buffer.append("\texports ");
                buffer.append(this.exports[i2].toString()).append('\n');
                ++i2;
            }
        }
        if (this.usedServices != null && this.usedServices.length > 0) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.usedServices.length) {
                buffer.append("\tuses ");
                buffer.append(this.usedServices[i2]).append('\n');
                ++i2;
            }
        }
        if (this.services != null && this.services.length > 0) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.services.length) {
                buffer.append("\tprovides ");
                buffer.append(this.services[i2].toString()).append('\n');
                ++i2;
            }
        }
        if (this.opens != null && this.opens.length > 0) {
            buffer.append('\n');
            i2 = 0;
            while (i2 < this.opens.length) {
                buffer.append("\topens ");
                buffer.append(this.opens[i2].toString()).append('\n');
                ++i2;
            }
        }
        buffer.append('\n').append('}').toString();
    }

    static class ModuleReferenceInfo
    extends MemberElementInfo
    implements IModule.IModuleReference {
        char[] name;
        int modifiers;

        ModuleReferenceInfo() {
        }

        @Override
        public char[] name() {
            return this.name;
        }

        @Override
        public int getModifiers() {
            return this.modifiers;
        }
    }

    static class PackageExportInfo
    extends MemberElementInfo
    implements IModule.IPackageExport {
        char[] pack;
        char[][] target;

        PackageExportInfo() {
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.pack);
            if (this.target != null) {
                buffer.append(" to ");
                char[][] cArray = this.target;
                int n = this.target.length;
                int n2 = 0;
                while (n2 < n) {
                    char[] mod = cArray[n2];
                    buffer.append(mod);
                    ++n2;
                }
            }
            buffer.append(';');
            return buffer.toString();
        }

        @Override
        public char[] name() {
            return this.pack;
        }

        @Override
        public char[][] targets() {
            return this.target;
        }
    }

    static class ServiceInfo
    extends MemberElementInfo
    implements IModule.IService {
        char[] serviceName;
        char[][] implNames;

        ServiceInfo() {
        }

        @Override
        public char[] name() {
            return this.serviceName;
        }

        @Override
        public char[][] with() {
            return this.implNames;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.serviceName);
            buffer.append(" with ");
            int i2 = 0;
            while (i2 < this.implNames.length) {
                buffer.append(this.implNames[i2]);
                if (i2 < this.implNames.length - 1) {
                    buffer.append(", ");
                }
                ++i2;
            }
            buffer.append(';');
            return buffer.toString();
        }
    }
}

