/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.nd.indexer;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.jdt.internal.compiler.env.ClassSignature;
import org.eclipse.jdt.internal.compiler.env.EnumConstantSignature;
import org.eclipse.jdt.internal.compiler.env.IBinaryAnnotation;
import org.eclipse.jdt.internal.compiler.env.IBinaryElementValuePair;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.IBinaryTypeAnnotation;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.core.nd.util.CharArrayUtils;

public class IndexTester {
    public static void testType(IBinaryType expected, IBinaryType actual) {
        String contextPrefix = IndexTester.safeString(actual.getName());
        IBinaryTypeAnnotation[] expectedTypeAnnotations = expected.getTypeAnnotations();
        IBinaryTypeAnnotation[] actualTypeAnnotations = actual.getTypeAnnotations();
        IndexTester.compareTypeAnnotations(contextPrefix, expectedTypeAnnotations, actualTypeAnnotations);
        IBinaryAnnotation[] expectedBinaryAnnotations = expected.getAnnotations();
        IBinaryAnnotation[] actualBinaryAnnotations = actual.getAnnotations();
        IndexTester.compareAnnotations(contextPrefix, expectedBinaryAnnotations, actualBinaryAnnotations);
        IndexTester.compareGenericSignatures(String.valueOf(contextPrefix) + ": The generic signature did not match", expected.getGenericSignature(), actual.getGenericSignature());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The enclosing method name did not match", expected.getEnclosingMethod(), actual.getEnclosingMethod());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The enclosing method name did not match", expected.getEnclosingTypeName(), actual.getEnclosingTypeName());
        IBinaryField[] expectedFields = expected.getFields();
        IBinaryField[] actualFields = actual.getFields();
        if (expectedFields != actualFields) {
            if (expectedFields == null && actualFields != null) {
                throw new IllegalStateException(String.valueOf(contextPrefix) + "Expected fields was null -- actual fields were not");
            }
            if (expectedFields.length != actualFields.length) {
                throw new IllegalStateException(String.valueOf(contextPrefix) + "The expected and actual number of fields did not match");
            }
            int fieldIdx = 0;
            while (fieldIdx < actualFields.length) {
                IndexTester.compareFields(contextPrefix, expectedFields[fieldIdx], actualFields[fieldIdx]);
                ++fieldIdx;
            }
        }
        IndexTester.assertEquals("The file name did not match", expected.getFileName(), actual.getFileName());
        IndexTester.assertEquals("The interface names did not match", expected.getInterfaceNames(), actual.getInterfaceNames());
        IBinaryMethod[] expectedMethods = expected.getMethods();
        IBinaryMethod[] actualMethods = actual.getMethods();
        if (expectedMethods != actualMethods) {
            if (expectedMethods == null || actualMethods == null) {
                throw new IllegalStateException("One of the method arrays was null");
            }
            if (expectedMethods.length != actualMethods.length) {
                throw new IllegalStateException("The number of methods didn't match");
            }
            int i2 = 0;
            while (i2 < actualMethods.length) {
                IBinaryMethod actualMethod = actualMethods[i2];
                IBinaryMethod expectedMethod = expectedMethods[i2];
                IndexTester.compareMethods(contextPrefix, expectedMethod, actualMethod);
                ++i2;
            }
        }
        IndexTester.assertEquals("The missing type names did not match", expected.getMissingTypeNames(), actual.getMissingTypeNames());
        IndexTester.assertEquals("The modifiers don't match", expected.getModifiers(), actual.getModifiers());
        IndexTester.assertEquals("The names don't match.", expected.getName(), actual.getName());
        IndexTester.assertEquals("The source name doesn't match", expected.getSourceName(), actual.getSourceName());
        IndexTester.assertEquals("The superclass name doesn't match", expected.getSuperclassName(), actual.getSuperclassName());
        IndexTester.assertEquals("The tag bits don't match.", expected.getTagBits(), actual.getTagBits());
        IndexTester.compareTypeAnnotations(contextPrefix, expected.getTypeAnnotations(), actual.getTypeAnnotations());
    }

    private static <T> void assertEquals(String message, T o1, T o2) {
        if (!IndexTester.isEqual(o1, o2)) {
            throw new IllegalStateException(String.valueOf(message) + ": expected = " + IndexTester.getString(o1) + ", actual = " + IndexTester.getString(o2));
        }
    }

    private static String getString(Object object) {
        if (object instanceof char[]) {
            char[] charArray = (char[])object;
            return new String(charArray);
        }
        return object.toString();
    }

    static <T> boolean isEqual(T o1, T o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof ClassSignature) {
            if (!(o2 instanceof ClassSignature)) {
                return false;
            }
            ClassSignature sig1 = (ClassSignature)o1;
            ClassSignature sig2 = (ClassSignature)o2;
            return Arrays.equals(sig1.getTypeName(), sig2.getTypeName());
        }
        if (o1 instanceof IBinaryAnnotation) {
            IBinaryElementValuePair[] otherElementValuePairs;
            IBinaryAnnotation binaryAnnotation = (IBinaryAnnotation)o1;
            IBinaryAnnotation otherBinaryAnnotation = (IBinaryAnnotation)o2;
            IBinaryElementValuePair[] elementValuePairs = binaryAnnotation.getElementValuePairs();
            if (elementValuePairs.length != (otherElementValuePairs = otherBinaryAnnotation.getElementValuePairs()).length) {
                return false;
            }
            int idx = 0;
            while (idx < elementValuePairs.length) {
                char[] otherNextName;
                IBinaryElementValuePair next = elementValuePairs[idx];
                IBinaryElementValuePair otherNext = otherElementValuePairs[idx];
                char[] nextName = next.getName();
                if (!Arrays.equals(nextName, otherNextName = otherNext.getName())) {
                    return false;
                }
                if (!IndexTester.isEqual(next.getValue(), otherNext.getValue())) {
                    return false;
                }
                ++idx;
            }
            return true;
        }
        if (o1 instanceof IBinaryTypeAnnotation) {
            IBinaryTypeAnnotation binaryAnnotation = (IBinaryTypeAnnotation)o1;
            IBinaryTypeAnnotation otherBinaryAnnotation = (IBinaryTypeAnnotation)o2;
            return new TypeAnnotationWrapper(binaryAnnotation).equals(new TypeAnnotationWrapper(otherBinaryAnnotation));
        }
        if (o1 instanceof Constant) {
            Constant d2;
            Constant d1;
            if (!(o2 instanceof Constant)) {
                return false;
            }
            if (o1 instanceof DoubleConstant && o2 instanceof DoubleConstant) {
                d1 = (DoubleConstant)o1;
                d2 = (DoubleConstant)o2;
                if (Double.isNaN(((DoubleConstant)d1).doubleValue()) && Double.isNaN(((DoubleConstant)d2).doubleValue())) {
                    return true;
                }
            }
            if (o1 instanceof FloatConstant && o2 instanceof FloatConstant) {
                d1 = (FloatConstant)o1;
                d2 = (FloatConstant)o2;
                if (Float.isNaN(((FloatConstant)d1).floatValue()) && Float.isNaN(((FloatConstant)d2).floatValue())) {
                    return true;
                }
            }
            Constant const1 = (Constant)o1;
            Constant const2 = (Constant)o2;
            return const1.hasSameValue(const2);
        }
        if (o1 instanceof EnumConstantSignature) {
            if (!(o2 instanceof EnumConstantSignature)) {
                return false;
            }
            EnumConstantSignature enum1 = (EnumConstantSignature)o1;
            EnumConstantSignature enum2 = (EnumConstantSignature)o2;
            return Arrays.equals(enum1.getEnumConstantName(), enum2.getEnumConstantName()) && Arrays.equals(enum1.getTypeName(), enum2.getTypeName());
        }
        if (o1 instanceof char[]) {
            char[] c1 = (char[])o1;
            char[] c2 = (char[])o2;
            return CharArrayUtils.equals(c1, c2);
        }
        if (o1 instanceof char[][]) {
            char[][] c1 = (char[][])o1;
            char[][] c2 = (char[][])o2;
            return CharArrayUtils.equals(c1, c2);
        }
        if (o1 instanceof char[][][]) {
            char[][][] c1 = (char[][][])o1;
            char[][][] c2 = (char[][][])o2;
            if (c1.length != c2.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < c1.length) {
                if (!IndexTester.isEqual(c1[i2], c2[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        if (o1 instanceof Object[]) {
            Object[] a1 = (Object[])o1;
            Object[] a2 = (Object[])o2;
            if (a1.length != a2.length) {
                return false;
            }
            int idx = 0;
            while (idx < a1.length) {
                if (!IndexTester.isEqual(a1[idx], a2[idx])) {
                    return false;
                }
                ++idx;
            }
            return true;
        }
        return Objects.equals(o1, o2);
    }

    private static void compareMethods(String contextPrefix, IBinaryMethod expectedMethod, IBinaryMethod actualMethod) {
        contextPrefix = String.valueOf(contextPrefix) + "." + IndexTester.safeString(expectedMethod.getSelector());
        IndexTester.compareAnnotations(contextPrefix, expectedMethod.getAnnotations(), actualMethod.getAnnotations());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The argument names didn't match.", expectedMethod.getArgumentNames(), actualMethod.getArgumentNames());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The default values didn't match.", expectedMethod.getDefaultValue(), actualMethod.getDefaultValue());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The exception type names did not match.", expectedMethod.getExceptionTypeNames(), actualMethod.getExceptionTypeNames());
        IndexTester.compareGenericSignatures(String.valueOf(contextPrefix) + ": The method's generic signature did not match", expectedMethod.getGenericSignature(), actualMethod.getGenericSignature());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The method descriptors did not match.", expectedMethod.getMethodDescriptor(), actualMethod.getMethodDescriptor());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The modifiers didn't match.", expectedMethod.getModifiers(), actualMethod.getModifiers());
        char[] classFileName = "".toCharArray();
        int minAnnotatedParameters = Math.min(expectedMethod.getAnnotatedParametersCount(), actualMethod.getAnnotatedParametersCount());
        int idx = 0;
        while (idx < minAnnotatedParameters) {
            IndexTester.compareAnnotations(contextPrefix, expectedMethod.getParameterAnnotations(idx, classFileName), actualMethod.getParameterAnnotations(idx, classFileName));
            ++idx;
        }
        idx = minAnnotatedParameters;
        while (idx < expectedMethod.getAnnotatedParametersCount()) {
            IndexTester.compareAnnotations(contextPrefix, new IBinaryAnnotation[0], expectedMethod.getParameterAnnotations(idx, classFileName));
            ++idx;
        }
        idx = minAnnotatedParameters;
        while (idx < actualMethod.getAnnotatedParametersCount()) {
            IndexTester.compareAnnotations(contextPrefix, new IBinaryAnnotation[0], actualMethod.getParameterAnnotations(idx, classFileName));
            ++idx;
        }
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The selectors did not match", expectedMethod.getSelector(), actualMethod.getSelector());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The tag bits did not match", expectedMethod.getTagBits(), actualMethod.getTagBits());
        IndexTester.compareTypeAnnotations(contextPrefix, expectedMethod.getTypeAnnotations(), actualMethod.getTypeAnnotations());
    }

    private static void compareGenericSignatures(String message, char[] expected, char[] actual) {
        IndexTester.assertEquals(message, expected, actual);
    }

    private static void compareTypeAnnotations(String contextPrefix, IBinaryTypeAnnotation[] expectedTypeAnnotations, IBinaryTypeAnnotation[] actualTypeAnnotations) {
        if (expectedTypeAnnotations == null) {
            if (actualTypeAnnotations != null) {
                throw new IllegalStateException(String.valueOf(contextPrefix) + ": Expected null for the annotation list but found: " + actualTypeAnnotations.toString());
            }
            return;
        }
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The expected and actual number of type annotations did not match", expectedTypeAnnotations.length, actualTypeAnnotations.length);
        int idx = 0;
        while (idx < expectedTypeAnnotations.length) {
            IndexTester.assertEquals(String.valueOf(contextPrefix) + ": Type annotation number " + idx + " did not match", expectedTypeAnnotations[idx], actualTypeAnnotations[idx]);
            ++idx;
        }
    }

    private static void compareAnnotations(String contextPrefix, IBinaryAnnotation[] expectedBinaryAnnotations, IBinaryAnnotation[] actualBinaryAnnotations) {
        if (expectedBinaryAnnotations == null || expectedBinaryAnnotations.length == 0) {
            if (actualBinaryAnnotations != null && actualBinaryAnnotations.length != 0) {
                throw new IllegalStateException(String.valueOf(contextPrefix) + ": Expected null for the binary annotations");
            }
            return;
        }
        if (actualBinaryAnnotations == null) {
            throw new IllegalStateException(String.valueOf(contextPrefix) + ": Actual null for the binary annotations");
        }
        if (expectedBinaryAnnotations.length != actualBinaryAnnotations.length) {
            throw new IllegalStateException(String.valueOf(contextPrefix) + ": The expected and actual number of annotations differed. Expected: " + expectedBinaryAnnotations.length + ", actual: " + actualBinaryAnnotations.length);
        }
        int idx = 0;
        while (idx < expectedBinaryAnnotations.length) {
            if (!IndexTester.isEqual(expectedBinaryAnnotations[idx], actualBinaryAnnotations[idx])) {
                throw new IllegalStateException(String.valueOf(contextPrefix) + ": An annotation had an unexpected value");
            }
            ++idx;
        }
    }

    private static void compareFields(String contextPrefix, IBinaryField field1, IBinaryField field2) {
        contextPrefix = String.valueOf(contextPrefix) + "." + IndexTester.safeString(field1.getName());
        IndexTester.compareAnnotations(contextPrefix, field1.getAnnotations(), field2.getAnnotations());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": Constants not equal", field1.getConstant(), field2.getConstant());
        IndexTester.compareGenericSignatures(String.valueOf(contextPrefix) + ": The generic signature did not match", field1.getGenericSignature(), field2.getGenericSignature());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The modifiers did not match", field1.getModifiers(), field2.getModifiers());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The tag bits did not match", field1.getTagBits(), field2.getTagBits());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The names did not match", field1.getName(), field2.getName());
        IndexTester.compareTypeAnnotations(contextPrefix, field1.getTypeAnnotations(), field2.getTypeAnnotations());
        IndexTester.assertEquals(String.valueOf(contextPrefix) + ": The type names did not match", field1.getTypeName(), field2.getTypeName());
    }

    private static String safeString(char[] name) {
        if (name == null) {
            return "<unnamed>";
        }
        return new String(name);
    }

    private static final class TypeAnnotationWrapper {
        private IBinaryTypeAnnotation annotation;

        public TypeAnnotationWrapper(IBinaryTypeAnnotation next) {
            this.annotation = next;
        }

        public int hashCode() {
            int[] typePath = this.annotation.getTypePath();
            int hashCode = Arrays.hashCode(typePath);
            hashCode = hashCode * 31 + this.annotation.getTargetType();
            hashCode = hashCode * 31 + this.annotation.getTypeParameterIndex();
            return hashCode;
        }

        public String toString() {
            return this.annotation.toString();
        }

        public boolean equals(Object obj) {
            int[] otherTypePath;
            if (obj.getClass() != TypeAnnotationWrapper.class) {
                return false;
            }
            TypeAnnotationWrapper wrapper = (TypeAnnotationWrapper)obj;
            IBinaryTypeAnnotation otherAnnotation = wrapper.annotation;
            int[] typePath = this.annotation.getTypePath();
            if (!Arrays.equals(typePath, otherTypePath = otherAnnotation.getTypePath())) {
                return false;
            }
            if (this.annotation.getTargetType() != otherAnnotation.getTargetType()) {
                return false;
            }
            if (this.annotation.getBoundIndex() != otherAnnotation.getBoundIndex()) {
                return false;
            }
            if (this.annotation.getMethodFormalParameterIndex() != otherAnnotation.getMethodFormalParameterIndex()) {
                return false;
            }
            if (this.annotation.getSupertypeIndex() != otherAnnotation.getSupertypeIndex()) {
                return false;
            }
            if (this.annotation.getThrowsTypeIndex() != otherAnnotation.getThrowsTypeIndex()) {
                return false;
            }
            if (this.annotation.getTypeParameterIndex() != otherAnnotation.getTypeParameterIndex()) {
                return false;
            }
            return IndexTester.isEqual(this.annotation.getAnnotation(), otherAnnotation.getAnnotation());
        }
    }
}

