/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.index.Index;
import org.eclipse.jdt.internal.core.search.IndexQueryRequestor;
import org.eclipse.jdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.jdt.internal.core.search.matching.JavaSearchPattern;
import org.eclipse.jdt.internal.core.search.matching.PackageDeclarationPattern;

public class OrPattern
extends SearchPattern
implements IIndexConstants {
    protected SearchPattern[] patterns;
    int matchCompatibility;

    public OrPattern(SearchPattern leftPattern, SearchPattern rightPattern) {
        super(Math.max(leftPattern.getMatchRule(), rightPattern.getMatchRule()));
        this.kind = 256;
        this.mustResolve = leftPattern.mustResolve || rightPattern.mustResolve;
        SearchPattern[] leftPatterns = leftPattern instanceof OrPattern ? ((OrPattern)leftPattern).patterns : null;
        SearchPattern[] rightPatterns = rightPattern instanceof OrPattern ? ((OrPattern)rightPattern).patterns : null;
        int leftSize = leftPatterns == null ? 1 : leftPatterns.length;
        int rightSize = rightPatterns == null ? 1 : rightPatterns.length;
        this.patterns = new SearchPattern[leftSize + rightSize];
        if (leftPatterns == null) {
            this.patterns[0] = leftPattern;
        } else {
            System.arraycopy(leftPatterns, 0, this.patterns, 0, leftSize);
        }
        if (rightPatterns == null) {
            this.patterns[leftSize] = rightPattern;
        } else {
            System.arraycopy(rightPatterns, 0, this.patterns, leftSize, rightSize);
        }
        this.matchCompatibility = 0;
        int i2 = 0;
        int length = this.patterns.length;
        while (i2 < length) {
            this.matchCompatibility |= ((JavaSearchPattern)this.patterns[i2]).matchCompatibility;
            ++i2;
        }
    }

    @Override
    public void findIndexMatches(Index index, IndexQueryRequestor requestor, SearchParticipant participant, IJavaSearchScope scope, IProgressMonitor progressMonitor) throws IOException {
        try {
            index.startQuery();
            int i2 = 0;
            int length = this.patterns.length;
            while (i2 < length) {
                this.patterns[i2].findIndexMatches(index, requestor, participant, scope, progressMonitor);
                ++i2;
            }
        }
        finally {
            index.stopQuery();
        }
    }

    @Override
    public SearchPattern getBlankPattern() {
        return null;
    }

    boolean isErasureMatch() {
        return (this.matchCompatibility & 0x10) != 0;
    }

    @Override
    public boolean isPolymorphicSearch() {
        int i2 = 0;
        int length = this.patterns.length;
        while (i2 < length) {
            if (this.patterns[i2].isPolymorphicSearch()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final boolean hasPackageDeclaration() {
        int i2 = 0;
        int length = this.patterns.length;
        while (i2 < length) {
            if (this.patterns[i2] instanceof PackageDeclarationPattern) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public final boolean hasSignatures() {
        boolean isErasureMatch = this.isErasureMatch();
        int i2 = 0;
        int length = this.patterns.length;
        while (i2 < length && !isErasureMatch) {
            if (((JavaSearchPattern)this.patterns[i2]).hasSignatures()) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.patterns[0].toString());
        int i2 = 1;
        int length = this.patterns.length;
        while (i2 < length) {
            buffer.append("\n| ");
            buffer.append(this.patterns[i2].toString());
            ++i2;
        }
        return buffer.toString();
    }
}

