/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import org.eclipse.jdt.core.util.ClassFormatException;
import org.eclipse.jdt.core.util.IConstantPool;
import org.eclipse.jdt.core.util.IParameterAnnotation;
import org.eclipse.jdt.core.util.IRuntimeVisibleParameterAnnotationsAttribute;
import org.eclipse.jdt.internal.core.util.ClassFileAttribute;
import org.eclipse.jdt.internal.core.util.ParameterAnnotation;

public class RuntimeVisibleParameterAnnotationsAttribute
extends ClassFileAttribute
implements IRuntimeVisibleParameterAnnotationsAttribute {
    private static final IParameterAnnotation[] NO_ENTRIES = new IParameterAnnotation[0];
    private int parametersNumber;
    private IParameterAnnotation[] parameterAnnotations;

    public RuntimeVisibleParameterAnnotationsAttribute(byte[] classFileBytes, IConstantPool constantPool, int offset) throws ClassFormatException {
        super(classFileBytes, constantPool, offset);
        int length;
        this.parametersNumber = length = this.u1At(classFileBytes, 6, offset);
        if (length != 0) {
            int readOffset = 7;
            this.parameterAnnotations = new IParameterAnnotation[length];
            int i2 = 0;
            while (i2 < length) {
                ParameterAnnotation parameterAnnotation = new ParameterAnnotation(classFileBytes, constantPool, offset + readOffset);
                this.parameterAnnotations[i2] = parameterAnnotation;
                readOffset += parameterAnnotation.sizeInBytes();
                ++i2;
            }
        } else {
            this.parameterAnnotations = NO_ENTRIES;
        }
    }

    @Override
    public IParameterAnnotation[] getParameterAnnotations() {
        return this.parameterAnnotations;
    }

    @Override
    public int getParametersNumber() {
        return this.parametersNumber;
    }
}

