/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import java.util.List;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FinallyFilter
implements IFilter {
    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        for (TryCatchBlockNode tryCatchBlock : methodNode.tryCatchBlocks) {
            if (tryCatchBlock.type != null) continue;
            FinallyFilter.filter(output, methodNode.tryCatchBlocks, tryCatchBlock);
        }
    }

    private static void filter(IFilterOutput output, List<TryCatchBlockNode> tryCatchBlocks, TryCatchBlockNode catchAnyBlock) {
        AbstractInsnNode e = FinallyFilter.next(catchAnyBlock.handler);
        int size = FinallyFilter.size(e);
        if (size <= 0) {
            return;
        }
        HashSet<LabelNode> inside = new HashSet<LabelNode>();
        for (TryCatchBlockNode t : tryCatchBlocks) {
            if (t.handler != catchAnyBlock.handler) continue;
            for (AbstractInsnNode i2 = t.start; i2 != t.end; i2 = i2.getNext()) {
                inside.add((LabelNode)i2);
            }
        }
        for (TryCatchBlockNode t : tryCatchBlocks) {
            AbstractInsnNode i3;
            if (t.handler == catchAnyBlock.handler) {
                AbstractInsnNode i4;
                boolean continues = false;
                block10: for (i4 = t.start; i4 != t.end; i4 = i4.getNext()) {
                    switch (i4.getType()) {
                        case 8: 
                        case 14: 
                        case 15: {
                            continue block10;
                        }
                        case 7: {
                            AbstractInsnNode jumpTarget = FinallyFilter.next(((JumpInsnNode)i4).label);
                            if (!inside.contains(jumpTarget)) {
                                FinallyFilter.merge(output, size, e, jumpTarget);
                            }
                            continues = i4.getOpcode() != 167;
                            continue block10;
                        }
                        default: {
                            switch (i4.getOpcode()) {
                                case 172: 
                                case 173: 
                                case 174: 
                                case 175: 
                                case 176: 
                                case 177: 
                                case 191: {
                                    continues = false;
                                    continue block10;
                                }
                            }
                            continues = true;
                        }
                    }
                }
                i4 = FinallyFilter.next(i4);
                if (continues && !inside.contains(i4)) {
                    FinallyFilter.merge(output, size, e, i4);
                }
            }
            if (t == catchAnyBlock || t.start != catchAnyBlock.start || t.end != catchAnyBlock.end || inside.contains(i3 = FinallyFilter.next(FinallyFilter.next(t.handler)))) continue;
            FinallyFilter.merge(output, size, e, i3);
        }
    }

    private static void merge(IFilterOutput output, int size, AbstractInsnNode e, AbstractInsnNode n) {
        if (!FinallyFilter.isSame(size, e, n)) {
            return;
        }
        output.ignore(e, e);
        e = FinallyFilter.next(e);
        for (int i2 = 0; i2 < size; ++i2) {
            output.merge(e, n);
            e = FinallyFilter.next(e);
            n = FinallyFilter.next(n);
        }
        output.ignore(e, FinallyFilter.next(e));
        if (n != null && n.getOpcode() == 167) {
            output.ignore(n, n);
        }
    }

    private static boolean isSame(int size, AbstractInsnNode e, AbstractInsnNode n) {
        e = FinallyFilter.next(e);
        for (int i2 = 0; i2 < size; ++i2) {
            if (n == null || e.getOpcode() != n.getOpcode()) {
                return false;
            }
            e = FinallyFilter.next(e);
            n = FinallyFilter.next(n);
        }
        return true;
    }

    private static int size(AbstractInsnNode i2) {
        if (58 != i2.getOpcode()) {
            return 0;
        }
        int var = ((VarInsnNode)i2).var;
        int size = -1;
        do {
            ++size;
            if ((i2 = FinallyFilter.next(i2)) != null) continue;
            return 0;
        } while (25 != i2.getOpcode() || var != ((VarInsnNode)i2).var);
        if (191 != (i2 = FinallyFilter.next(i2)).getOpcode()) {
            return 0;
        }
        return size;
    }

    private static AbstractInsnNode next(AbstractInsnNode i2) {
        while ((i2 = i2.getNext()) != null && (14 == i2.getType() || 8 == i2.getType() || 15 == i2.getType())) {
        }
        return i2;
    }
}

