/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.core.internal.analysis.filter;

import java.util.HashSet;
import java.util.List;
import org.jacoco.core.internal.analysis.filter.AbstractMatcher;
import org.jacoco.core.internal.analysis.filter.IFilter;
import org.jacoco.core.internal.analysis.filter.IFilterContext;
import org.jacoco.core.internal.analysis.filter.IFilterOutput;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LookupSwitchInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TableSwitchInsnNode;

public final class KotlinWhenFilter
implements IFilter {
    private static final String EXCEPTION = "kotlin/NoWhenBranchMatchedException";

    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        Matcher matcher = new Matcher();
        for (AbstractInsnNode i2 : methodNode.instructions) {
            matcher.match(i2, output);
        }
    }

    private static LabelNode getDefaultLabel(AbstractInsnNode i2) {
        switch (i2.getOpcode()) {
            case 171: {
                return ((LookupSwitchInsnNode)i2).dflt;
            }
            case 170: {
                return ((TableSwitchInsnNode)i2).dflt;
            }
        }
        return null;
    }

    private static void ignoreDefaultBranch(AbstractInsnNode switchNode, IFilterOutput output) {
        List<LabelNode> labels = switchNode.getOpcode() == 171 ? ((LookupSwitchInsnNode)switchNode).labels : ((TableSwitchInsnNode)switchNode).labels;
        HashSet<AbstractInsnNode> newTargets = new HashSet<AbstractInsnNode>();
        for (LabelNode label : labels) {
            newTargets.add(AbstractMatcher.skipNonOpcodes(label));
        }
        output.replaceBranches(switchNode, newTargets);
    }

    private static class Matcher
    extends AbstractMatcher {
        private Matcher() {
        }

        void match(AbstractInsnNode start, IFilterOutput output) {
            if (start.getType() != 8) {
                return;
            }
            this.cursor = start;
            this.nextIsType(187, KotlinWhenFilter.EXCEPTION);
            this.nextIs(89);
            this.nextIsInvoke(183, KotlinWhenFilter.EXCEPTION, "<init>", "()V");
            this.nextIs(191);
            for (AbstractInsnNode i2 = this.cursor; i2 != null; i2 = i2.getPrevious()) {
                if (i2.getOpcode() == 153 && ((JumpInsnNode)i2).label == start) {
                    output.ignore(i2, i2);
                    output.ignore(start, this.cursor);
                    return;
                }
                if (KotlinWhenFilter.getDefaultLabel(i2) != start) continue;
                KotlinWhenFilter.ignoreDefaultBranch(i2, output);
                output.ignore(start, this.cursor);
                return;
            }
        }
    }
}

