/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.StringUtils;

class ParameterizedTestNameFormatter {
    private final String pattern;
    private final String displayName;

    ParameterizedTestNameFormatter(String pattern, String displayName) {
        this.pattern = pattern;
        this.displayName = displayName;
    }

    String format(int invocationIndex, Object ... arguments) {
        String pattern = this.prepareMessageFormatPattern(invocationIndex, arguments);
        Object[] humanReadableArguments = this.makeReadable(arguments);
        return this.formatSafely(pattern, humanReadableArguments);
    }

    private String prepareMessageFormatPattern(int invocationIndex, Object[] arguments) {
        String result = this.pattern.replace("{displayName}", this.displayName).replace("{index}", String.valueOf(invocationIndex));
        if (result.contains("{arguments}")) {
            String replacement = IntStream.range(0, arguments.length).mapToObj(index -> "{" + index + "}").collect(Collectors.joining(", "));
            result = result.replace("{arguments}", replacement);
        }
        return result;
    }

    private Object[] makeReadable(Object[] arguments) {
        Object[] humanReadableArguments = Arrays.stream(arguments).map(StringUtils::nullSafeToString).toArray(String[]::new);
        return humanReadableArguments;
    }

    private String formatSafely(String pattern, Object[] arguments) {
        try {
            return MessageFormat.format(pattern, arguments);
        }
        catch (IllegalArgumentException ex) {
            String message = "The display name pattern defined for the parameterized test is invalid. See nested exception for further details.";
            throw new JUnitException(message, ex);
        }
    }
}

