/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.classinfo;

import java.util.Map;
import java.util.Optional;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.FixedSizeHashMap;

public class CachingByteArraySource
implements ClassByteArraySource {
    private final ClassByteArraySource child;
    private final Map<String, Optional<byte[]>> cache;

    public CachingByteArraySource(ClassByteArraySource child, int maxSize) {
        this.child = child;
        this.cache = new FixedSizeHashMap<String, Optional<byte[]>>(maxSize);
    }

    @Override
    public Optional<byte[]> getBytes(String clazz) {
        Optional<byte[]> maybeBytes = this.cache.get(clazz);
        if (maybeBytes != null) {
            return maybeBytes;
        }
        maybeBytes = this.child.getBytes(clazz);
        this.cache.put(clazz, maybeBytes);
        return maybeBytes;
    }
}

