/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.util.Objects;
import org.pitest.classinfo.ClassName;
import org.pitest.mutationtest.engine.Location;

public final class BlockLocation {
    private final Location location;
    private final int block;
    private final int firstInsnInBlock;
    private final int lastInsnInBlock;

    public BlockLocation(Location location, int block, int firstInsnInBlock, int lastInsnInBlock) {
        this.location = location;
        this.block = block;
        this.firstInsnInBlock = firstInsnInBlock;
        this.lastInsnInBlock = lastInsnInBlock;
    }

    public static BlockLocation blockLocation(Location location, int block) {
        return new BlockLocation(location, block, -1, -1);
    }

    public boolean isFor(ClassName clazz) {
        return this.location.getClassName().equals(clazz);
    }

    public int getBlock() {
        return this.block;
    }

    public Location getLocation() {
        return this.location;
    }

    public int getFirstInsnInBlock() {
        return this.firstInsnInBlock;
    }

    public int getLastInsnInBlock() {
        return this.lastInsnInBlock;
    }

    public int hashCode() {
        return Objects.hash(this.location, this.block);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockLocation other = (BlockLocation)obj;
        return this.block == other.block && Objects.equals(this.location, other.location);
    }

    public String toString() {
        return "BlockLocation [location=" + this.location + ", block=" + this.block + "]";
    }
}

