/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockCoverage;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.CoverageResult;
import org.pitest.coverage.CoverageSummary;
import org.pitest.coverage.InstructionLocation;
import org.pitest.coverage.LegacyClassCoverage;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.FCollection;
import org.pitest.testapi.Description;
import org.pitest.util.Log;

public class CoverageData
implements CoverageDatabase {
    private static final Logger LOG = Log.getLogger();
    private final Map<InstructionLocation, Set<TestInfo>> instructionCoverage = new LinkedHashMap<InstructionLocation, Set<TestInfo>>();
    private final LegacyClassCoverage legacyClassCoverage;
    private final CodeSource code;
    private final List<Description> failingTestDescriptions = new ArrayList<Description>();

    public CoverageData(CodeSource code, LineMap lm) {
        this.code = code;
        this.legacyClassCoverage = new LegacyClassCoverage(code, lm);
    }

    public void calculateClassCoverage(CoverageResult cr) {
        this.checkForFailedTest(cr);
        TestInfo ti = this.createTestInfo(cr.getTestUnitDescription(), cr.getExecutionTime(), cr.getNumberOfCoveredBlocks());
        this.legacyClassCoverage.addTestToClasses(ti, cr.getCoverage());
        for (BlockLocation each : cr.getCoverage()) {
            for (int i2 = each.getFirstInsnInBlock(); i2 <= each.getLastInsnInBlock(); ++i2) {
                this.addTestsToBlockMap(ti, new InstructionLocation(each, i2));
            }
        }
    }

    public void loadBlockDataOnly(Collection<BlockLocation> coverageData) {
        this.legacyClassCoverage.loadBlockDataOnly(coverageData);
    }

    @Override
    public Collection<TestInfo> getTestsForInstructionLocation(InstructionLocation location) {
        return this.instructionCoverage.getOrDefault(location, Collections.emptySet());
    }

    @Override
    public Collection<TestInfo> getTestsForClassLine(ClassLine classLine) {
        return this.legacyClassCoverage.getTestsForClassLine(classLine);
    }

    public boolean allTestsGreen() {
        return this.failingTestDescriptions.isEmpty();
    }

    public int getCountFailedTests() {
        return this.failingTestDescriptions.size();
    }

    public List<Description> getFailingTestDescriptions() {
        return this.failingTestDescriptions;
    }

    @Override
    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return this.code.getClassInfo(classes);
    }

    @Override
    public int getNumberOfCoveredLines(Collection<ClassName> mutatedClass) {
        return this.legacyClassCoverage.getNumberOfCoveredLines(mutatedClass);
    }

    @Override
    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        return this.legacyClassCoverage.getTestsForClass(clazz);
    }

    private void addTestsToBlockMap(TestInfo ti, InstructionLocation each) {
        Set<TestInfo> tests = this.instructionCoverage.get(each);
        if (tests == null) {
            tests = new TreeSet<TestInfo>(new TestInfoNameComparator());
            this.instructionCoverage.put(each, tests);
        }
        tests.add(ti);
    }

    @Override
    public BigInteger getCoverageIdForClass(ClassName clazz) {
        Collection<TestInfo> coverage = this.getTestsForClass(clazz);
        if (coverage.isEmpty()) {
            return BigInteger.ZERO;
        }
        return this.generateCoverageNumber(coverage);
    }

    public List<BlockCoverage> createCoverage() {
        return FCollection.map(this.instructionCoverage.entrySet(), CoverageData.toBlockCoverage());
    }

    private static Function<Map.Entry<InstructionLocation, Set<TestInfo>>, BlockCoverage> toBlockCoverage() {
        return a -> new BlockCoverage(((InstructionLocation)a.getKey()).getBlockLocation(), FCollection.map((Iterable)a.getValue(), TestInfo.toName()));
    }

    @Override
    public Collection<ClassInfo> getClassesForFile(String sourceFile, String packageName) {
        return this.legacyClassCoverage.getClassesForFile(sourceFile, packageName);
    }

    @Override
    public CoverageSummary createSummary() {
        return new CoverageSummary(this.numberOfLines(), this.coveredLines());
    }

    private BigInteger generateCoverageNumber(Collection<TestInfo> coverage) {
        BigInteger coverageNumber = BigInteger.ZERO;
        Set<ClassName> testClasses = coverage.stream().map(TestInfo.toDefiningClassName()).collect(Collectors.toSet());
        for (ClassInfo each : this.code.getClassInfo(testClasses)) {
            coverageNumber = coverageNumber.add(each.getDeepHash());
        }
        return coverageNumber;
    }

    private Collection<ClassName> allClasses() {
        return this.code.getCodeUnderTestNames();
    }

    private int numberOfLines() {
        return FCollection.fold(this.numberLines(), 0, this.code.getClassInfo(this.allClasses()));
    }

    private int coveredLines() {
        return this.getNumberOfCoveredLines(this.allClasses());
    }

    private BiFunction<Integer, ClassInfo, Integer> numberLines() {
        return (a, clazz) -> a + clazz.getNumberOfCodeLines();
    }

    private void checkForFailedTest(CoverageResult cr) {
        if (!cr.isGreenTest()) {
            this.recordTestFailure(cr.getTestUnitDescription());
            LOG.severe(cr.getTestUnitDescription() + " did not pass without mutation.");
        }
    }

    private TestInfo createTestInfo(Description description, int executionTime, int linesCovered) {
        Optional<ClassName> testee = this.code.findTestee(description.getFirstTestClass());
        return new TestInfo(description.getFirstTestClass(), description.getQualifiedName(), executionTime, testee, linesCovered);
    }

    private void recordTestFailure(Description testDescription) {
        this.failingTestDescriptions.add(testDescription);
    }
}

