/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.pitest.classinfo.ClassInfo;
import org.pitest.classinfo.ClassName;
import org.pitest.classpath.CodeSource;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.ClassLine;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.ReportCoverage;
import org.pitest.coverage.TestInfo;
import org.pitest.coverage.TestInfoNameComparator;
import org.pitest.functional.FCollection;

public class LegacyClassCoverage
implements ReportCoverage {
    private final CodeSource code;
    private final Map<String, Collection<ClassInfo>> classesForFile;
    private final Map<ClassName, Map<ClassLine, Set<TestInfo>>> lineCoverage = new LinkedHashMap<ClassName, Map<ClassLine, Set<TestInfo>>>();
    private final Map<BlockLocation, Set<Integer>> blocksToLines = new LinkedHashMap<BlockLocation, Set<Integer>>();
    private final LineMap lm;

    public LegacyClassCoverage(CodeSource code, LineMap lm) {
        this.code = code;
        this.lm = lm;
        this.classesForFile = FCollection.bucket(code.getCode(), LegacyClassCoverage.keyFromClassInfo());
    }

    public void loadBlockDataOnly(Collection<BlockLocation> coverageData) {
        this.addTestToClasses(new TestInfo("fake", "fakeTest", 0, Optional.empty(), 1), coverageData);
    }

    @Override
    public Collection<ClassInfo> getClassInfo(Collection<ClassName> classes) {
        return this.code.getClassInfo(classes);
    }

    @Override
    public int getNumberOfCoveredLines(Collection<ClassName> mutatedClass) {
        return mutatedClass.stream().map(this::getLineCoverageForClassName).mapToInt(Map::size).sum();
    }

    @Override
    public Collection<TestInfo> getTestsForClassLine(ClassLine classLine) {
        Collection result = this.getLineCoverageForClassName(classLine.getClassName()).get(classLine);
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public Collection<ClassInfo> getClassesForFile(String sourceFile, String packageName) {
        Collection<ClassInfo> value = this.classesForFile.get(LegacyClassCoverage.keyFromSourceAndPackage(sourceFile, packageName));
        if (value == null) {
            return Collections.emptyList();
        }
        return value;
    }

    public Collection<TestInfo> getTestsForClass(ClassName clazz) {
        return this.lineCoverage.getOrDefault(clazz, Collections.emptyMap()).values().stream().flatMap(s -> s.stream()).collect(Collectors.toSet());
    }

    void addTestToClasses(TestInfo ti, Collection<BlockLocation> coverage) {
        for (BlockLocation each : coverage) {
            ClassName clazz = each.getLocation().getClassName();
            Map linesToTests = this.lineCoverage.getOrDefault(clazz, new LinkedHashMap(0));
            for (int line : this.getLinesForBlock(each)) {
                this.addTestToClassLine(each.getLocation().getClassName(), linesToTests, ti, line);
            }
            this.lineCoverage.put(each.getLocation().getClassName(), linesToTests);
        }
    }

    private void addTestToClassLine(ClassName clazz, Map<ClassLine, Set<TestInfo>> linesToTests, TestInfo test, int line) {
        ClassLine cl = new ClassLine(clazz, line);
        Set tis = linesToTests.getOrDefault(cl, new TreeSet<TestInfo>(new TestInfoNameComparator()));
        tis.add(test);
        linesToTests.put(cl, tis);
    }

    private Map<ClassLine, Set<TestInfo>> getLineCoverageForClassName(ClassName clazz) {
        return this.lineCoverage.getOrDefault(clazz, Collections.emptyMap());
    }

    private static Function<ClassInfo, String> keyFromClassInfo() {
        return c -> LegacyClassCoverage.keyFromSourceAndPackage(c.getSourceFileName(), c.getName().getPackage().asJavaName());
    }

    private static String keyFromSourceAndPackage(String sourceFile, String packageName) {
        return packageName + " " + sourceFile;
    }

    private Set<Integer> getLinesForBlock(BlockLocation bl) {
        Set<Integer> lines = this.blocksToLines.get(bl);
        if (lines == null) {
            this.calculateLinesForBlocks(bl.getLocation().getClassName());
            lines = this.blocksToLines.get(bl);
            if (lines == null) {
                lines = Collections.emptySet();
            }
        }
        return lines;
    }

    private void calculateLinesForBlocks(ClassName className) {
        Map<BlockLocation, Set<Integer>> lines = this.lm.mapLines(className);
        this.blocksToLines.putAll(lines);
    }
}

