/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.List;
import org.pitest.coverage.CoverageClassVisitor;
import org.pitest.coverage.analysis.ArrayProbeCoverageMethodVisitor;
import org.pitest.coverage.analysis.Block;
import org.pitest.coverage.analysis.ControlFlowAnalyser;
import org.pitest.mutationtest.engine.gregor.analysis.DefaultInstructionCounter;
import org.pitest.mutationtest.engine.gregor.analysis.InstructionTrackingMethodVisitor;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.tree.MethodNode;
import sun.pitest.CodeCoverageStore;

public class CoverageAnalyser
extends MethodNode {
    private final CoverageClassVisitor parent;
    private final int classId;
    private final MethodVisitor mv;
    private final int probeOffset;

    public CoverageAnalyser(CoverageClassVisitor parent, int classId, int probeOffset, MethodVisitor mv, int access, String name, String desc, String signature, String[] exceptions) {
        super(589824, access, name, desc, signature, exceptions);
        this.mv = mv;
        this.parent = parent;
        this.classId = classId;
        this.probeOffset = probeOffset;
    }

    @Override
    public void visitEnd() {
        List<Block> blocks = this.findRequriedProbeLocations();
        this.parent.registerProbes(blocks.size());
        CodeCoverageStore.registerMethod(this.classId, this.name, this.desc, this.probeOffset, this.probeOffset + blocks.size() - 1, blocks);
        DefaultInstructionCounter counter = new DefaultInstructionCounter();
        this.accept(new InstructionTrackingMethodVisitor(new ArrayProbeCoverageMethodVisitor(blocks, counter, this.classId, this.mv, this.access, this.parent.getClassName(), this.name, this.desc, this.probeOffset), counter));
    }

    private List<Block> findRequriedProbeLocations() {
        return ControlFlowAnalyser.analyze(this);
    }
}

