/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.coverage.analysis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.pitest.classinfo.ClassByteArraySource;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.LineMap;
import org.pitest.coverage.analysis.Block;
import org.pitest.coverage.analysis.ControlFlowAnalyser;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.reloc.asm.ClassReader;
import org.pitest.reloc.asm.tree.ClassNode;
import org.pitest.reloc.asm.tree.MethodNode;

public class LineMapper
implements LineMap {
    private final ClassByteArraySource source;

    public LineMapper(ClassByteArraySource source) {
        this.source = source;
    }

    @Override
    public Map<BlockLocation, Set<Integer>> mapLines(ClassName clazz) {
        HashMap<BlockLocation, Set<Integer>> map = new HashMap<BlockLocation, Set<Integer>>();
        Optional<byte[]> maybeBytes = this.source.getBytes(clazz.asInternalName());
        if (maybeBytes.isPresent()) {
            ClassReader cr = new ClassReader(maybeBytes.get());
            ClassNode classNode = new ClassNode();
            cr.accept(classNode, 8);
            Iterator<MethodNode> iterator = classNode.methods.iterator();
            while (iterator.hasNext()) {
                MethodNode m;
                MethodNode mn = m = iterator.next();
                Location l = Location.location(clazz, MethodName.fromString(mn.name), mn.desc);
                List<Block> blocks = ControlFlowAnalyser.analyze(mn);
                for (int i2 = 0; i2 != blocks.size(); ++i2) {
                    Block each = blocks.get(i2);
                    BlockLocation bl = new BlockLocation(l, i2, each.getFirstInstruction(), each.getLastInstruction());
                    map.put(bl, each.getLines());
                }
            }
        }
        return map;
    }
}

