/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class FCollection {
    public static <A, B> void mapTo(Iterable<? extends A> as, Function<A, B> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                bs.add(f.apply(a));
            }
        }
    }

    public static <A, B> List<B> map(Iterable<? extends A> as, Function<A, B> f) {
        List bs = FCollection.emptyList();
        FCollection.mapTo(as, f, bs);
        return bs;
    }

    public static <A, B> void flatMapTo(Iterable<? extends A> as, Function<A, ? extends Iterable<B>> f, Collection<? super B> bs) {
        if (as != null) {
            for (A a : as) {
                for (B each : f.apply(a)) {
                    bs.add(each);
                }
            }
        }
    }

    public static <A, B> List<B> flatMap(Iterable<? extends A> as, Function<A, ? extends Iterable<B>> f) {
        List bs = FCollection.emptyList();
        FCollection.flatMapTo(as, f, bs);
        return bs;
    }

    private static <T> List<T> emptyList() {
        return new ArrayList();
    }

    public static <T> List<T> filter(Iterable<? extends T> xs, Predicate<T> predicate) {
        List<T> dest = FCollection.emptyList();
        FCollection.filter(xs, predicate, dest);
        return dest;
    }

    public static <T> void filter(Iterable<? extends T> xs, Predicate<T> predicate, Collection<? super T> dest) {
        for (T x : xs) {
            if (!predicate.test(x)) continue;
            dest.add(x);
        }
    }

    public static <T> boolean contains(Iterable<? extends T> xs, Predicate<T> predicate) {
        for (T x : xs) {
            if (!predicate.test(x)) continue;
            return true;
        }
        return false;
    }

    public static <A, B> A fold(BiFunction<A, B, A> f, A z, Iterable<? extends B> xs) {
        A p = z;
        for (B x : xs) {
            p = f.apply(p, x);
        }
        return p;
    }

    public static <T> Collection<T> flatten(Iterable<? extends Iterable<? extends T>> ts) {
        ArrayList<T> list = new ArrayList<T>();
        for (Iterable<T> it : ts) {
            for (T each : it) {
                list.add(each);
            }
        }
        return list;
    }

    public static <T> List<List<T>> splitToLength(int targetLength, Iterable<T> ts) {
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        ArrayList<T> temp = new ArrayList<T>();
        int i2 = 0;
        for (T each : ts) {
            if (i2 == targetLength) {
                list.add(temp);
                temp = new ArrayList();
                i2 = 0;
            }
            temp.add(each);
            ++i2;
        }
        if (!temp.isEmpty()) {
            list.add(temp);
        }
        return list;
    }

    public static <A, B> Map<A, Collection<B>> bucket(Iterable<B> bs, Function<B, A> f) {
        HashMap<Object, Collection> bucketed = new HashMap<Object, Collection>();
        for (B each : bs) {
            A key = f.apply(each);
            Collection existing = bucketed.computeIfAbsent(key, k -> new ArrayList());
            existing.add(each);
        }
        return bucketed;
    }
}

