/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.functional.prelude;

import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.pitest.functional.predicate.And;
import org.pitest.functional.predicate.Or;

public abstract class Prelude {
    @SafeVarargs
    public static <A> And<A> and(Predicate<A> ... ps) {
        return new And<A>(Arrays.asList(ps));
    }

    public static <A> And<A> and(Iterable<? extends Predicate<A>> ps) {
        return new And(ps);
    }

    public static <A> Predicate<A> not(Predicate<A> p) {
        return p.negate();
    }

    @SafeVarargs
    public static <A> Or<A> or(Predicate<A> ... ps) {
        return new Or<A>(Arrays.asList(ps));
    }

    public static <A> Or<A> or(Iterable<Predicate<A>> ps) {
        return new Or<A>(ps);
    }

    public static <A> Consumer<A> accumulateTo(Collection<A> collection) {
        return collection::add;
    }

    public static <A, B> Consumer<A> putToMap(Map<A, B> map, B value) {
        return key -> map.put(key, value);
    }

    public static <A> Function<A, A> id() {
        return a -> a;
    }

    public static <A> Function<A, A> id(Class<A> type) {
        return Prelude.id();
    }

    public static <T> Consumer<T> println() {
        return Prelude.printlnTo(System.out);
    }

    public static <T> Consumer<T> println(Class<T> type) {
        return Prelude.println();
    }

    public static <T> Consumer<T> printlnTo(Class<T> type, PrintStream stream) {
        return Prelude.printlnTo(stream);
    }

    public static <T> Consumer<T> printlnTo(PrintStream stream) {
        return stream::println;
    }

    public static <T> Consumer<T> printlnWith(T t) {
        return a -> System.out.println(t + " : " + a);
    }

    public static <T extends Number> Predicate<T> isGreaterThan(T value) {
        return o -> o.longValue() > value.longValue();
    }

    public static <T> Function<T, Iterable<T>> asList(Class<T> type) {
        return Collections::singletonList;
    }

    public static <T> Consumer<T> noSideEffect(Class<T> clazz) {
        return a -> {};
    }
}

