/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runners.Parameterized;
import org.pitest.functional.FCollection;
import org.pitest.junit.DescriptionFilter;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.reflection.IsAnnotatedWith;
import org.pitest.reflection.Reflection;
import org.pitest.testapi.TestGroupConfig;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;
import org.pitest.util.IsolationUtils;

public class JUnitCustomRunnerTestUnitFinder
implements TestUnitFinder {
    private static final Optional<Class> CLASS_RULE = JUnitCustomRunnerTestUnitFinder.findClassRuleClass();
    private final TestGroupConfig config;
    private final Collection<String> excludedRunners;
    private final Collection<String> includedTestMethods;

    JUnitCustomRunnerTestUnitFinder(TestGroupConfig config, Collection<String> excludedRunners, Collection<String> includedTestMethods) {
        Objects.requireNonNull(config);
        this.config = config;
        this.excludedRunners = excludedRunners;
        this.includedTestMethods = includedTestMethods;
    }

    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(clazz);
        if (this.isExcluded(runner) || this.isNotARunnableTest(runner, clazz.getName()) || !this.isIncluded(clazz)) {
            return Collections.emptyList();
        }
        if (Filterable.class.isAssignableFrom(runner.getClass()) && !this.shouldTreatAsOneUnit(clazz, runner)) {
            List<TestUnit> filteredUnits = this.splitIntoFilteredUnits(runner.getDescription());
            return this.filterUnitsByMethod(filteredUnits);
        }
        return Collections.singletonList(new AdaptedJUnitTestUnit(clazz, Optional.empty()));
    }

    private List<TestUnit> filterUnitsByMethod(List<TestUnit> filteredUnits) {
        if (this.includedTestMethods.isEmpty()) {
            return filteredUnits;
        }
        ArrayList<TestUnit> units = new ArrayList<TestUnit>();
        for (TestUnit unit : filteredUnits) {
            if (!this.includedTestMethods.contains(unit.getDescription().getName().split("\\(")[0])) continue;
            units.add(unit);
        }
        return units;
    }

    private boolean isExcluded(Runner runner) {
        return this.excludedRunners.contains(runner.getClass().getName());
    }

    private boolean isIncluded(Class<?> a) {
        return this.isIncludedCategory(a) && !this.isExcludedCategory(a);
    }

    private boolean isIncludedCategory(Class<?> a) {
        List<String> included = this.config.getIncludedGroups();
        return included.isEmpty() || !Collections.disjoint(included, this.getCategories(a));
    }

    private boolean isExcludedCategory(Class<?> a) {
        List<String> excluded = this.config.getExcludedGroups();
        return !excluded.isEmpty() && !Collections.disjoint(excluded, this.getCategories(a));
    }

    private List<String> getCategories(Class<?> a) {
        Category c = a.getAnnotation(Category.class);
        return FCollection.flatMap(Arrays.asList(c), this.toCategoryNames());
    }

    private Function<Category, Iterable<String>> toCategoryNames() {
        return a -> {
            if (a == null) {
                return Collections.emptyList();
            }
            return FCollection.map(Arrays.asList(a.value()), Class::getName);
        };
    }

    private boolean isNotARunnableTest(Runner runner, String className) {
        try {
            return runner == null || runner.getClass().isAssignableFrom(ErrorReportingRunner.class) || this.isParameterizedTest(runner) || this.isAJUnitThreeErrorOrWarning(runner) || this.isJUnitThreeSuiteMethodNotForOwnClass(runner, className);
        }
        catch (RuntimeException ex) {
            return true;
        }
    }

    private boolean isAJUnitThreeErrorOrWarning(Runner runner) {
        return !runner.getDescription().getChildren().isEmpty() && runner.getDescription().getChildren().get(0).getClassName().startsWith("junit.framework.TestSuite");
    }

    private boolean shouldTreatAsOneUnit(Class<?> clazz, Runner runner) {
        Set<Method> methods = Reflection.allMethods(clazz);
        return this.runnerCannotBeSplit(runner) || this.hasAnnotation(methods, BeforeClass.class) || this.hasAnnotation(methods, AfterClass.class) || this.hasClassRuleAnnotations(clazz, methods);
    }

    private boolean hasClassRuleAnnotations(Class<?> clazz, Set<Method> methods) {
        return CLASS_RULE.filter(aClass -> this.hasAnnotation((Set<? extends AccessibleObject>)methods, (Class<? extends Annotation>)aClass) || this.hasAnnotation((Set<? extends AccessibleObject>)Reflection.publicFields(clazz), (Class<? extends Annotation>)aClass)).isPresent();
    }

    private boolean hasAnnotation(Set<? extends AccessibleObject> methods, Class<? extends Annotation> annotation) {
        return FCollection.contains(methods, IsAnnotatedWith.instance(annotation));
    }

    private boolean isParameterizedTest(Runner runner) {
        return Parameterized.class.isAssignableFrom(runner.getClass());
    }

    private boolean runnerCannotBeSplit(Runner runner) {
        String runnerName = runner.getClass().getName();
        return runnerName.equals("junitparams.JUnitParamsRunner") || runnerName.startsWith("org.spockframework.runtime.Sputnik") || runnerName.startsWith("com.insightfullogic.lambdabehave") || runnerName.startsWith("com.googlecode.yatspec") || runnerName.startsWith("com.google.gwtmockito.GwtMockitoTestRunner");
    }

    private boolean isJUnitThreeSuiteMethodNotForOwnClass(Runner runner, String className) {
        return runner.getClass().getName().equals("org.junit.internal.runners.SuiteMethod") && !runner.getDescription().getClassName().equals(className);
    }

    private List<TestUnit> splitIntoFilteredUnits(Description description) {
        return description.getChildren().stream().filter(Description::isTest).map(this::descriptionToTest).collect(Collectors.toList());
    }

    private TestUnit descriptionToTest(Description description) {
        Class<?> clazz = description.getTestClass();
        if (clazz == null) {
            clazz = IsolationUtils.convertForClassLoader(IsolationUtils.getContextClassLoader(), description.getClassName());
        }
        return new AdaptedJUnitTestUnit(clazz, Optional.ofNullable(this.createFilterFor(description)));
    }

    private Filter createFilterFor(Description description) {
        return new DescriptionFilter(description.toString());
    }

    private static Optional<Class> findClassRuleClass() {
        try {
            return Optional.ofNullable(Class.forName("org.junit.ClassRule"));
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }
}

