/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.junit.internal.runners.ErrorReportingRunner;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.pitest.functional.FCollection;
import org.pitest.junit.ParameterisedTestFilter;
import org.pitest.junit.adapter.AdaptedJUnitTestUnit;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;

public class ParameterisedJUnitTestFinder
implements TestUnitFinder {
    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        Runner runner = AdaptedJUnitTestUnit.createRunner(clazz);
        if (runner == null || runner.getClass().isAssignableFrom(ErrorReportingRunner.class)) {
            return Collections.emptyList();
        }
        if (this.isParameterizedTest(runner)) {
            return this.handleParameterizedTest(clazz, runner.getDescription());
        }
        return Collections.emptyList();
    }

    private List<TestUnit> handleParameterizedTest(Class<?> clazz, Description description) {
        ArrayList<TestUnit> result = new ArrayList<TestUnit>();
        for (Description each : description.getChildren()) {
            FCollection.mapTo(each.getChildren(), this.parameterizedToTestUnit(clazz), result);
        }
        return result;
    }

    private Function<Description, TestUnit> parameterizedToTestUnit(Class<?> clazz) {
        return a -> new AdaptedJUnitTestUnit(clazz, Optional.ofNullable(new ParameterisedTestFilter(a.toString())));
    }

    private boolean isParameterizedTest(Runner runner) {
        return Parameterized.class.isAssignableFrom(runner.getClass());
    }
}

