/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.junit5;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.pitest.junit5.JUnit5TestUnit;
import org.pitest.testapi.TestUnit;
import org.pitest.testapi.TestUnitFinder;

public class JUnit5TestUnitFinder
implements TestUnitFinder {
    private final Launcher launcher = LauncherFactory.create();

    @Override
    public List<TestUnit> findTestUnits(Class<?> clazz) {
        if (clazz.getEnclosingClass() != null) {
            return Collections.emptyList();
        }
        TestPlan testPlan = this.launcher.discover(LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClass(clazz)).build());
        return testPlan.getRoots().stream().map(testPlan::getDescendants).flatMap(Collection::stream).filter(testIdentifier -> testIdentifier.getSource().isPresent()).filter(testIdentifier -> testIdentifier.getSource().get() instanceof MethodSource).map(testIdentifier -> new JUnit5TestUnit(clazz, (TestIdentifier)testIdentifier)).collect(Collectors.toList());
    }
}

