/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.DetectionStatus;
import org.pitest.mutationtest.MutationResult;
import org.pitest.mutationtest.MutationStatusTestPair;
import org.pitest.mutationtest.engine.MutationDetails;

public class MutationStatusMap {
    private final Map<MutationDetails, MutationStatusTestPair> mutationMap = new HashMap<MutationDetails, MutationStatusTestPair>();

    public void setStatusForMutation(MutationDetails mutation, DetectionStatus status) {
        this.setStatusForMutations(Collections.singleton(mutation), status);
    }

    public void setStatusForMutation(MutationDetails mutation, MutationStatusTestPair status) {
        this.mutationMap.put(mutation, status);
    }

    public void setStatusForMutations(Collection<MutationDetails> mutations, DetectionStatus status) {
        mutations.forEach(Prelude.putToMap(this.mutationMap, MutationStatusTestPair.notAnalysed(0, status)));
    }

    public List<MutationResult> createMutationResults() {
        return FCollection.map(this.mutationMap.entrySet(), MutationStatusMap.detailsToMutationResults());
    }

    public boolean hasUnrunMutations() {
        return !this.getUnrunMutations().isEmpty();
    }

    public Collection<MutationDetails> getUnrunMutations() {
        return this.mutationMap.entrySet().stream().filter(MutationStatusMap.hasStatus(DetectionStatus.NOT_STARTED)).map(MutationStatusMap.toMutationDetails()).collect(Collectors.toList());
    }

    public Collection<MutationDetails> getUnfinishedRuns() {
        return this.mutationMap.entrySet().stream().filter(MutationStatusMap.hasStatus(DetectionStatus.STARTED)).map(MutationStatusMap.toMutationDetails()).collect(Collectors.toList());
    }

    public Set<MutationDetails> allMutations() {
        return this.mutationMap.keySet();
    }

    private static Function<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationResult> detailsToMutationResults() {
        return a -> new MutationResult((MutationDetails)a.getKey(), (MutationStatusTestPair)a.getValue());
    }

    private static Function<Map.Entry<MutationDetails, MutationStatusTestPair>, MutationDetails> toMutationDetails() {
        return Map.Entry::getKey;
    }

    private static Predicate<Map.Entry<MutationDetails, MutationStatusTestPair>> hasStatus(DetectionStatus status) {
        return a -> ((MutationStatusTestPair)a.getValue()).getStatus().equals((Object)status);
    }

    public void markUncoveredMutations() {
        this.setStatusForMutations(FCollection.filter(this.mutationMap.keySet(), MutationStatusMap.hasNoCoverage()), DetectionStatus.NO_COVERAGE);
    }

    private static Predicate<MutationDetails> hasNoCoverage() {
        return a -> a.getTestsInOrder().isEmpty();
    }
}

