/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.pitest.classinfo.ClassName;
import org.pitest.coverage.BlockLocation;
import org.pitest.coverage.CoverageDatabase;
import org.pitest.coverage.InstructionLocation;
import org.pitest.coverage.TestInfo;
import org.pitest.mutationtest.build.TestInfoPriorisationComparator;
import org.pitest.mutationtest.build.TestPrioritiser;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.util.Log;

public class DefaultTestPrioritiser
implements TestPrioritiser {
    private static final Logger LOG = Log.getLogger();
    private static final int TIME_WEIGHTING_FOR_DIRECT_UNIT_TESTS = 1000;
    private final CoverageDatabase coverage;

    public DefaultTestPrioritiser(CoverageDatabase coverage) {
        this.coverage = coverage;
    }

    @Override
    public List<TestInfo> assignTests(MutationDetails mutation) {
        return this.prioritizeTests(mutation.getClassName(), this.pickTests(mutation));
    }

    private Collection<TestInfo> pickTests(MutationDetails mutation) {
        if (!mutation.isInStaticInitializer()) {
            if (mutation.getId().getIndexes().size() > 1) {
                HashSet<TestInfo> ret = new HashSet<TestInfo>();
                for (int each : mutation.getId().getIndexes()) {
                    Collection<TestInfo> r = this.coverage.getTestsForInstructionLocation(new InstructionLocation(new BlockLocation(mutation.getId().getLocation(), mutation.getBlock(), -1, -1), each - 1));
                    if (r == null) continue;
                    ret.addAll(r);
                }
                return ret;
            }
            return this.coverage.getTestsForInstructionLocation(new InstructionLocation(new BlockLocation(mutation.getId().getLocation(), mutation.getBlock(), -1, -1), mutation.getId().getFirstIndex() - 1));
        }
        LOG.warning("Using untargetted tests");
        return this.coverage.getTestsForClass(mutation.getClassName());
    }

    private List<TestInfo> prioritizeTests(ClassName clazz, Collection<TestInfo> testsForMutant) {
        ArrayList<TestInfo> sortedTis = new ArrayList<TestInfo>(testsForMutant);
        sortedTis.sort(new TestInfoPriorisationComparator(clazz, 1000));
        return sortedTis;
    }
}

