/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build;

import java.io.File;
import java.util.Collection;
import java.util.function.Consumer;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.MutationConfig;
import org.pitest.mutationtest.TimeoutLengthStrategy;
import org.pitest.mutationtest.config.TestPluginArguments;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.execute.MinionArguments;
import org.pitest.mutationtest.execute.MutationTestProcess;
import org.pitest.process.ProcessArgs;
import org.pitest.util.Log;
import org.pitest.util.SocketFinder;

public class WorkerFactory {
    private final String classPath;
    private final File baseDir;
    private final TestPluginArguments pitConfig;
    private final TimeoutLengthStrategy timeoutStrategy;
    private final boolean verbose;
    private final boolean fullMutationMatrix;
    private final MutationConfig config;
    private final EngineArguments args;

    public WorkerFactory(File baseDir, TestPluginArguments pitConfig, MutationConfig mutationConfig, EngineArguments args, TimeoutLengthStrategy timeoutStrategy, boolean verbose, boolean fullMutationMatrix, String classPath) {
        this.pitConfig = pitConfig;
        this.timeoutStrategy = timeoutStrategy;
        this.verbose = verbose;
        this.fullMutationMatrix = fullMutationMatrix;
        this.classPath = classPath;
        this.baseDir = baseDir;
        this.config = mutationConfig;
        this.args = args;
    }

    public MutationTestProcess createWorker(Collection<MutationDetails> remainingMutations, Collection<ClassName> testClasses) {
        MinionArguments fileArgs = new MinionArguments(remainingMutations, testClasses, this.config.getEngine().getName(), this.args, this.timeoutStrategy, Log.isVerbose(), this.fullMutationMatrix, this.pitConfig);
        ProcessArgs args = ProcessArgs.withClassPath(this.classPath).andLaunchOptions(this.config.getLaunchOptions()).andBaseDir(this.baseDir).andStdout(this.captureStdOutIfVerbose()).andStderr(Prelude.printlnWith("stderr "));
        SocketFinder sf = new SocketFinder();
        return new MutationTestProcess(sf.getNextAvailableServerSocket(), args, fileArgs);
    }

    private Consumer<String> captureStdOutIfVerbose() {
        if (this.verbose) {
            return Prelude.printlnWith("stdout ");
        }
        return Prelude.noSideEffect(String.class);
    }
}

