/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.javafeatures;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.functional.FCollection;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.build.intercept.javafeatures.LineMutatorPair;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.util.Log;

public class InlinedFinallyBlockFilter
implements MutationInterceptor {
    private static final Logger LOG = Log.getLogger();

    @Override
    public InterceptorType type() {
        return InterceptorType.FILTER;
    }

    @Override
    public void begin(ClassTree clazz) {
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        ArrayList<MutationDetails> combined = new ArrayList<MutationDetails>(mutations.size());
        Map<LineMutatorPair, Collection<MutationDetails>> mutatorLinebuckets = FCollection.bucket(mutations, InlinedFinallyBlockFilter.toLineMutatorPair());
        for (Map.Entry<LineMutatorPair, Collection<MutationDetails>> each : mutatorLinebuckets.entrySet()) {
            if (each.getValue().size() > 1) {
                this.checkForInlinedCode(combined, each);
                continue;
            }
            combined.addAll(each.getValue());
        }
        combined.sort(InlinedFinallyBlockFilter.compareLineNumbers());
        return combined;
    }

    @Override
    public void end() {
    }

    private static Comparator<MutationDetails> compareLineNumbers() {
        return Comparator.comparingInt(MutationDetails::getLineNumber);
    }

    private void checkForInlinedCode(Collection<MutationDetails> combined, Map.Entry<LineMutatorPair, Collection<MutationDetails>> each) {
        List<MutationDetails> mutationsInHandlerBlock = FCollection.filter((Iterable)each.getValue(), MutationDetails::isInFinallyBlock);
        if (!this.isPossibleToCorrectInlining(mutationsInHandlerBlock)) {
            combined.addAll(each.getValue());
            return;
        }
        MutationDetails baseMutation = mutationsInHandlerBlock.get(0);
        int firstBlock = baseMutation.getBlock();
        List<Integer> ids = FCollection.map((Iterable)each.getValue(), MutationDetails::getBlock);
        if (ids.stream().anyMatch(Prelude.not(Predicate.isEqual(firstBlock)))) {
            combined.add(InlinedFinallyBlockFilter.makeCombinedMutant(each.getValue()));
        } else {
            combined.addAll(each.getValue());
        }
    }

    private boolean isPossibleToCorrectInlining(List<MutationDetails> mutationsInHandlerBlock) {
        if (mutationsInHandlerBlock.size() > 1) {
            LOG.warning("Found more than one mutation similar on same line in a finally block. Can't correct for inlining.");
            return false;
        }
        return !mutationsInHandlerBlock.isEmpty();
    }

    private static MutationDetails makeCombinedMutant(Collection<MutationDetails> value) {
        MutationDetails first = value.iterator().next();
        HashSet<Integer> indexes = new HashSet<Integer>();
        FCollection.mapTo(value, MutationDetails::getFirstIndex, indexes);
        MutationIdentifier id = new MutationIdentifier(first.getId().getLocation(), indexes, first.getId().getMutator());
        return new MutationDetails(id, first.getFilename(), first.getDescription(), first.getLineNumber(), first.getBlock());
    }

    private static Function<MutationDetails, LineMutatorPair> toLineMutatorPair() {
        return a -> new LineMutatorPair(a.getLineNumber(), a.getMutator());
    }
}

