/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.build.intercept.staticinitializers;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.pitest.bytecode.analysis.AnalysisFunctions;
import org.pitest.bytecode.analysis.ClassTree;
import org.pitest.bytecode.analysis.MethodTree;
import org.pitest.classinfo.ClassName;
import org.pitest.functional.FCollection;
import org.pitest.functional.predicate.Or;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.build.InterceptorType;
import org.pitest.mutationtest.build.MutationInterceptor;
import org.pitest.mutationtest.engine.MethodName;
import org.pitest.mutationtest.engine.Mutater;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.PoisonStatus;

class StaticInitializerInterceptor
implements MutationInterceptor {
    private static final MethodName CLINIT = MethodName.fromString("<clinit>");
    private Predicate<MutationDetails> isStaticInitCode;

    StaticInitializerInterceptor() {
    }

    @Override
    public void begin(ClassTree clazz) {
        this.analyseClass(clazz);
    }

    @Override
    public Collection<MutationDetails> intercept(Collection<MutationDetails> mutations, Mutater m) {
        if (this.isStaticInitCode != null) {
            List altered = mutations.stream().filter(this.isStaticInitCode).map(this.setStaticInitializerFlag()).collect(Collectors.toList());
            List<MutationDetails> notAltered = FCollection.filter(mutations, Prelude.not(this.isStaticInitCode));
            notAltered.addAll(altered);
            return notAltered;
        }
        return mutations;
    }

    @Override
    public void end() {
        this.isStaticInitCode = null;
    }

    private void analyseClass(ClassTree tree) {
        Optional<MethodTree> clinit = tree.methods().stream().filter(this.nameEquals(CLINIT.name())).findFirst();
        if (clinit.isPresent()) {
            List selfCalls = clinit.get().instructions().stream().flatMap(this.is(MethodInsnNode.class)).filter(this.calls(tree.name())).map(StaticInitializerInterceptor::matchesCall).collect(Collectors.toList());
            Or matchingCalls = Prelude.or(selfCalls);
            Or initOnlyMethods = Prelude.or(tree.methods().stream().filter(StaticInitializerInterceptor.isPrivateStatic()).filter(matchingCalls).map(AnalysisFunctions.matchMutationsInMethod()).collect(Collectors.toList()));
            this.isStaticInitCode = Prelude.or(StaticInitializerInterceptor.isInStaticInitializer(), initOnlyMethods);
        }
    }

    private static Predicate<MutationDetails> isInStaticInitializer() {
        return a -> a.getId().getLocation().getMethodName().equals(CLINIT);
    }

    private static Predicate<MethodTree> isPrivateStatic() {
        return a -> (a.rawNode().access & 8) != 0 && (a.rawNode().access & 2) != 0;
    }

    private static Predicate<MethodTree> matchesCall(MethodInsnNode call) {
        return a -> a.rawNode().name.equals(call.name) && a.rawNode().desc.equals(call.desc);
    }

    private Predicate<MethodInsnNode> calls(ClassName self) {
        return a -> a.owner.equals(self.asInternalName());
    }

    private <T extends AbstractInsnNode> Function<AbstractInsnNode, Stream<T>> is(Class<T> clazz) {
        return a -> {
            if (a.getClass().isAssignableFrom(clazz)) {
                return Stream.of(a);
            }
            return Stream.empty();
        };
    }

    private Predicate<MethodTree> nameEquals(String name) {
        return a -> a.rawNode().name.equals(name);
    }

    private Function<MutationDetails, MutationDetails> setStaticInitializerFlag() {
        return a -> a.withPoisonStatus(PoisonStatus.IS_STATIC_INITIALIZER_CODE);
    }

    @Override
    public InterceptorType type() {
        return InterceptorType.MODIFY;
    }
}

