/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.Map;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.ZeroOperandMutation;
import org.pitest.reloc.asm.MethodVisitor;

public abstract class AbstractInsnMutator
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;
    private final MethodInfo methodInfo;

    public AbstractInsnMutator(MethodMutatorFactory factory, MethodInfo methodInfo, MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(589824, delegateMethodVisitor);
        this.factory = factory;
        this.methodInfo = methodInfo;
        this.context = context;
    }

    protected abstract Map<Integer, ZeroOperandMutation> getMutations();

    @Override
    public void visitInsn(int opcode) {
        if (this.canMutate(opcode)) {
            this.createMutationForInsnOpcode(opcode);
        } else {
            this.mv.visitInsn(opcode);
        }
    }

    protected boolean canMutate(int opcode) {
        return this.getMutations().containsKey(opcode);
    }

    private void createMutationForInsnOpcode(int opcode) {
        ZeroOperandMutation mutation = this.getMutations().get(opcode);
        MutationIdentifier newId = this.context.registerMutation(this.factory, mutation.describe(opcode, this.methodInfo));
        if (this.context.shouldMutate(newId)) {
            mutation.apply(opcode, this.mv);
        } else {
            this.applyUnmutatedInstruction(opcode);
        }
    }

    private void applyUnmutatedInstruction(int opcode) {
        this.mv.visitInsn(opcode);
    }

    protected MethodInfo methodInfo() {
        return this.methodInfo;
    }
}

