/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor;

import java.util.HashSet;
import java.util.Set;
import org.pitest.mutationtest.engine.Location;
import org.pitest.mutationtest.engine.MutationDetails;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.PoisonStatus;
import org.pitest.mutationtest.engine.gregor.ClassContext;
import org.pitest.mutationtest.engine.gregor.ClassInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.mutationtest.engine.gregor.analysis.InstructionCounter;

class MethodMutationContext
implements MutationContext,
InstructionCounter {
    private final ClassContext classContext;
    private final Location location;
    private int instructionIndex;
    private int lastLineNumber;
    private final Set<String> mutationFindingDisabledReasons = new HashSet<String>();

    MethodMutationContext(ClassContext classContext, Location location) {
        this.classContext = classContext;
        this.location = location;
    }

    @Override
    public MutationIdentifier registerMutation(MethodMutatorFactory factory, String description) {
        MutationIdentifier newId = this.getNextMutationIdentifer(factory, this.classContext.getJavaClassName());
        MutationDetails details = new MutationDetails(newId, this.classContext.getFileName(), description, this.lastLineNumber, this.classContext.getCurrentBlock(), this.classContext.isWithinFinallyBlock(), PoisonStatus.NORMAL);
        this.registerMutation(details);
        return newId;
    }

    private MutationIdentifier getNextMutationIdentifer(MethodMutatorFactory factory, String className) {
        return new MutationIdentifier(this.location, this.instructionIndex, factory.getGloballyUniqueId());
    }

    private void registerMutation(MutationDetails details) {
        if (!this.isMutationFindingDisabled()) {
            this.classContext.addMutation(details);
        }
    }

    private boolean isMutationFindingDisabled() {
        return !this.mutationFindingDisabledReasons.isEmpty();
    }

    @Override
    public void registerCurrentLine(int line) {
        this.lastLineNumber = line;
    }

    @Override
    public void registerNewBlock() {
        this.classContext.registerNewBlock();
    }

    @Override
    public void registerNewMethodStart() {
        this.classContext.registerNewMethodStart();
    }

    @Override
    public void registerFinallyBlockStart() {
        this.classContext.registerFinallyBlockStart();
    }

    @Override
    public void registerFinallyBlockEnd() {
        this.classContext.registerFinallyBlockEnd();
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.classContext.getClassInfo();
    }

    @Override
    public boolean shouldMutate(MutationIdentifier newId) {
        return this.classContext.shouldMutate(newId);
    }

    @Override
    public void disableMutations(String reason) {
        this.mutationFindingDisabledReasons.add(reason);
    }

    @Override
    public void enableMutatations(String reason) {
        this.mutationFindingDisabledReasons.remove(reason);
    }

    @Override
    public void increment() {
        ++this.instructionIndex;
    }

    @Override
    public int currentInstructionCount() {
        return this.instructionIndex;
    }
}

