/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.blocks;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.pitest.coverage.analysis.Block;
import org.pitest.coverage.analysis.ControlFlowAnalyser;
import org.pitest.mutationtest.engine.gregor.blocks.BlockCounter;
import org.pitest.reloc.asm.Handle;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.tree.MethodNode;

public class BlockTrackingMethodDecorator
extends MethodNode {
    private final BlockCounter blockCounter;
    private final MethodVisitor cmv;

    public BlockTrackingMethodDecorator(BlockCounter blockCounter, MethodVisitor mv, int acc, String name, String desc, String signature, String[] exceptions) {
        super(589824, acc, name, desc, signature, exceptions);
        this.cmv = mv;
        this.blockCounter = blockCounter;
    }

    @Override
    public void visitEnd() {
        super.visitEnd();
        final LinkedList<Block> blocks = new LinkedList<Block>(ControlFlowAnalyser.analyze(this));
        this.blockCounter.registerNewMethodStart();
        this.accept(new MethodVisitor(589824, this.cmv){
            Block curBlock;
            int i;
            private final Set<Label> handlers;
            {
                super(x0, x1);
                this.curBlock = (Block)blocks.pop();
                this.handlers = new HashSet<Label>();
            }

            @Override
            public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                super.visitTryCatchBlock(start, end, handler, type);
                if (type == null) {
                    this.handlers.add(handler);
                }
            }

            private boolean endsBlock(int opcode) {
                switch (opcode) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: 
                    case 191: {
                        return true;
                    }
                }
                return false;
            }

            private void visitAnything() {
                if (this.i == this.curBlock.getFirstInstruction()) {
                    if (this.i == 0) {
                        if (!blocks.isEmpty()) {
                            this.curBlock = (Block)blocks.pop();
                        }
                    } else {
                        BlockTrackingMethodDecorator.this.blockCounter.registerNewBlock();
                        if (!blocks.isEmpty()) {
                            this.curBlock = (Block)blocks.pop();
                        }
                    }
                }
                ++this.i;
            }

            @Override
            public void visitFrame(int type, int numLocal, Object[] local, int numStack, Object[] stack) {
                this.visitAnything();
                super.visitFrame(type, numLocal, local, numStack, stack);
            }

            @Override
            public void visitInsn(int opcode) {
                this.visitAnything();
                super.visitInsn(opcode);
                if (this.endsBlock(opcode)) {
                    BlockTrackingMethodDecorator.this.blockCounter.registerFinallyBlockEnd();
                }
            }

            @Override
            public void visitIntInsn(int opcode, int operand) {
                this.visitAnything();
                super.visitIntInsn(opcode, operand);
            }

            @Override
            public void visitVarInsn(int opcode, int var) {
                this.visitAnything();
                super.visitVarInsn(opcode, var);
            }

            @Override
            public void visitTypeInsn(int opcode, String type) {
                this.visitAnything();
                super.visitTypeInsn(opcode, type);
            }

            @Override
            public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
                this.visitAnything();
                super.visitFieldInsn(opcode, owner, name, descriptor);
            }

            @Override
            public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
                this.visitAnything();
                super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
            }

            @Override
            public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
                this.visitAnything();
                super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
            }

            @Override
            public void visitJumpInsn(int opcode, Label label) {
                this.visitAnything();
                super.visitJumpInsn(opcode, label);
            }

            @Override
            public void visitLabel(Label label) {
                this.visitAnything();
                if (this.handlers.contains(label)) {
                    BlockTrackingMethodDecorator.this.blockCounter.registerFinallyBlockStart();
                }
                super.visitLabel(label);
            }

            @Override
            public void visitLdcInsn(Object value) {
                this.visitAnything();
                super.visitLdcInsn(value);
            }

            @Override
            public void visitIincInsn(int var, int increment) {
                this.visitAnything();
                super.visitIincInsn(var, increment);
            }

            @Override
            public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
                this.visitAnything();
                super.visitTableSwitchInsn(min, max, dflt, labels);
            }

            @Override
            public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                this.visitAnything();
                super.visitLookupSwitchInsn(dflt, keys, labels);
            }

            @Override
            public void visitMultiANewArrayInsn(String descriptor, int numDimensions) {
                this.visitAnything();
                super.visitMultiANewArrayInsn(descriptor, numDimensions);
            }

            @Override
            public void visitLineNumber(int line, Label start) {
                this.visitAnything();
                super.visitLineNumber(line, start);
            }
        });
    }
}

