/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.config;

import java.util.Collection;
import java.util.function.Predicate;
import org.pitest.functional.predicate.Or;
import org.pitest.functional.prelude.Prelude;
import org.pitest.mutationtest.EngineArguments;
import org.pitest.mutationtest.MutationEngineFactory;
import org.pitest.mutationtest.engine.MutationEngine;
import org.pitest.mutationtest.engine.gregor.GregorMutationEngine;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.config.DefaultMutationEngineConfiguration;
import org.pitest.mutationtest.engine.gregor.config.Mutator;
import org.pitest.util.Glob;

public final class GregorEngineFactory
implements MutationEngineFactory {
    @Override
    public MutationEngine createEngine(EngineArguments args) {
        return this.createEngineWithMutators(args.excludedMethods(), GregorEngineFactory.createMutatorListFromArrayOrUseDefaults(args.mutators()));
    }

    public MutationEngine createEngineWithMutators(Collection<String> excludedMethods, Collection<? extends MethodMutatorFactory> mutators) {
        Predicate<MethodInfo> filter = Prelude.not(GregorEngineFactory.stringToMethodInfoPredicate(excludedMethods));
        DefaultMutationEngineConfiguration config = new DefaultMutationEngineConfiguration(filter, mutators);
        return new GregorMutationEngine(config);
    }

    private static Collection<? extends MethodMutatorFactory> createMutatorListFromArrayOrUseDefaults(Collection<String> mutators) {
        if (mutators != null && !mutators.isEmpty()) {
            return Mutator.fromStrings(mutators);
        }
        return Mutator.newDefaults();
    }

    private static Predicate<MethodInfo> stringToMethodInfoPredicate(Collection<String> excludedMethods) {
        Or excluded = Prelude.or(Glob.toGlobPredicates(excludedMethods));
        return a -> excluded.test(a.getName());
    }

    @Override
    public String name() {
        return "gregor";
    }

    @Override
    public String description() {
        return "Default mutation engine";
    }
}

