/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Handle;
import org.pitest.reloc.asm.MethodVisitor;

public enum BigIntegerMutator implements MethodMutatorFactory
{
    INSTANCE;


    @Override
    public MethodVisitor create(MutationContext context, MethodInfo info, MethodVisitor visitor) {
        return new BigIntegerMathMutator(this, context, visitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    public String toString() {
        return "EXPERIMENTAL_BIGINTEGER_MUTATOR";
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private static final class BigIntegerMathMutator
    extends MethodVisitor {
        private static final Map<String, Replacement> REPLACEMENTS;
        private final MethodMutatorFactory factory;
        private final MutationContext context;
        private final String expectedOwner = "java/math/BigInteger";

        private static void put(Map<String, Replacement> map, Replacement replacement) {
            map.put(replacement.sourceName, replacement);
        }

        private BigIntegerMathMutator(MethodMutatorFactory factory, MutationContext context, MethodVisitor visitor) {
            super(393216, visitor);
            this.factory = factory;
            this.context = context;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            MutationIdentifier identifier;
            if (!owner.equals("java/math/BigInteger") || opcode != 182) {
                this.mv.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
                return;
            }
            Replacement replacement = REPLACEMENTS.get(name);
            if (replacement != null && replacement.descriptor.equals(descriptor) && this.context.shouldMutate(identifier = this.context.registerMutation(this.factory, replacement.toString()))) {
                this.mv.visitMethodInsn(opcode, owner, replacement.destinationName, replacement.descriptor, false);
                return;
            }
            this.mv.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        @Override
        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            bootstrapMethodHandle = this.mutateHandle(bootstrapMethodHandle);
            Object[] methodArgs = new Object[bootstrapMethodArguments.length];
            for (int i2 = 0; i2 < bootstrapMethodArguments.length; ++i2) {
                Object bootstrapMethodArgument = bootstrapMethodArguments[i2];
                methodArgs[i2] = bootstrapMethodArgument instanceof Handle ? this.mutateHandle((Handle)bootstrapMethodArgument) : bootstrapMethodArgument;
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, methodArgs);
        }

        private Handle mutateHandle(Handle handle) {
            MutationIdentifier id;
            Replacement replacement;
            int opcode = handle.getTag();
            String owner = handle.getOwner();
            String name = handle.getName();
            String descriptor = handle.getDesc();
            if (owner.equals("java/math/BigInteger") && opcode == 5 && REPLACEMENTS.containsKey(name) && (replacement = REPLACEMENTS.get(name)).descriptor.equals(descriptor) && this.context.shouldMutate(id = this.context.registerMutation(this.factory, replacement.toString()))) {
                return new Handle(opcode, owner, replacement.destinationName, descriptor, handle.isInterface());
            }
            return handle;
        }

        static {
            HashMap<String, Replacement> map = new HashMap<String, Replacement>();
            String unary = "(Ljava/math/BigInteger;)Ljava/math/BigInteger;";
            BigIntegerMathMutator.put(map, new Replacement("add", "subtract", unary));
            BigIntegerMathMutator.put(map, new Replacement("subtract", "add", unary));
            BigIntegerMathMutator.put(map, new Replacement("multiply", "divide", unary));
            BigIntegerMathMutator.put(map, new Replacement("divide", "multiply", unary));
            BigIntegerMathMutator.put(map, new Replacement("mod", "multiply", unary));
            BigIntegerMathMutator.put(map, new Replacement("remainder", "multiply", unary));
            BigIntegerMathMutator.put(map, new Replacement("and", "or", unary));
            BigIntegerMathMutator.put(map, new Replacement("or", "and", unary));
            BigIntegerMathMutator.put(map, new Replacement("xor", "and", unary));
            BigIntegerMathMutator.put(map, new Replacement("andNot", "and", unary));
            BigIntegerMathMutator.put(map, new Replacement("max", "min", unary));
            BigIntegerMathMutator.put(map, new Replacement("min", "max", unary));
            String unaryPrimitive = "(I)Ljava/math/BigInteger;";
            BigIntegerMathMutator.put(map, new Replacement("shiftLeft", "shiftRight", unaryPrimitive));
            BigIntegerMathMutator.put(map, new Replacement("shiftRight", "shiftLeft", unaryPrimitive));
            String intAsParam = "(I)Ljava/math/BigInteger;";
            BigIntegerMathMutator.put(map, new Replacement("setBit", "clearBit", intAsParam));
            BigIntegerMathMutator.put(map, new Replacement("clearBit", "setBit", intAsParam));
            BigIntegerMathMutator.put(map, new Replacement("flipBit", "setBit", intAsParam));
            String noParams = "()Ljava/math/BigInteger;";
            BigIntegerMathMutator.put(map, new Replacement("not", "negate", noParams));
            BigIntegerMathMutator.put(map, new Replacement("negate", "not", noParams));
            BigIntegerMathMutator.put(map, new Replacement("abs", "negate", noParams));
            REPLACEMENTS = Collections.unmodifiableMap(map);
        }

        private static final class Replacement {
            private final String sourceName;
            private final String destinationName;
            private final String descriptor;

            Replacement(String sourceName, String destinationName, String descriptor) {
                this.sourceName = sourceName;
                this.destinationName = destinationName;
                this.descriptor = descriptor;
            }

            public String toString() {
                String template = "Replaced BigInteger#%s with BigInteger#%s.";
                return String.format(template, this.sourceName, this.destinationName);
            }
        }
    }
}

