/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public enum NakedReceiverMutator implements MethodMutatorFactory
{
    NAKED_RECEIVER;


    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new ReplaceMethodCallWithObjectVisitor(context, methodVisitor, this);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return this.name();
    }

    static class ReplaceMethodCallWithObjectVisitor
    extends MethodVisitor {
        private final MethodMutatorFactory factory;
        private final MutationContext context;

        ReplaceMethodCallWithObjectVisitor(MutationContext context, MethodVisitor writer, MethodMutatorFactory factory) {
            super(589824, writer);
            this.factory = factory;
            this.context = context;
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (this.isNonStaticCall(opcode) && this.hasReturnTypeMatchingReceiverType(desc, owner)) {
                MutationIdentifier newId = this.context.registerMutation(this.factory, "replaced call to " + owner + "::" + name + " with receiver");
                if (this.context.shouldMutate(newId)) {
                    this.popMethodArgumentsFromStack(desc);
                    return;
                }
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            } else {
                this.mv.visitMethodInsn(opcode, owner, name, desc, itf);
            }
        }

        private boolean hasReturnTypeMatchingReceiverType(String desc, String owner) {
            return Type.getObjectType(owner).equals(Type.getReturnType(desc));
        }

        private void popMethodArgumentsFromStack(String desc) {
            Type[] argumentTypes;
            for (Type argType : argumentTypes = Type.getArgumentTypes(desc)) {
                this.popArgument(argType);
            }
        }

        private void popArgument(Type argumentType) {
            if (argumentType.getSize() != 1) {
                this.mv.visitInsn(88);
            } else {
                this.mv.visitInsn(87);
            }
        }

        private boolean isNonStaticCall(int opcode) {
            return 184 != opcode;
        }
    }
}

