/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.experimental;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodInfo;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.Label;
import org.pitest.reloc.asm.MethodVisitor;
import org.pitest.reloc.asm.Type;

public class ReturnValuesMutator
implements MethodMutatorFactory {
    private static final ObjectMutationMethod OBJECT_MUTATION_METHOD = new ObjectMutationMethod();
    private static final ObjectReferenceReplacer SINGLETON_REPLACER = new ObjectReferenceReplacer();

    public static Object mutateObjectInstance(Object object, Class<?> clazz) {
        return ReturnValuesMutator.SINGLETON_REPLACER.replaceObjectInstance(object, clazz);
    }

    @Override
    public MethodVisitor create(MutationContext context, MethodInfo methodInfo, MethodVisitor methodVisitor) {
        return new ReturnValuesMethodVisitor(context, methodInfo, methodVisitor);
    }

    @Override
    public String getGloballyUniqueId() {
        return this.getClass().getName();
    }

    @Override
    public String getName() {
        return "EXPERIMENTAL_RETURN_VALUES_MUTATOR";
    }

    private final class ReturnValuesMethodVisitor
    extends MethodVisitor {
        private static final String DESCRIPTION_MESSAGE_PATTERN = "replaced return of %s value with %s";
        private final MutationContext context;
        private final MethodInfo methodInfo;

        private ReturnValuesMethodVisitor(MutationContext context, MethodInfo methodInfo, MethodVisitor delegateVisitor) {
            super(589824, delegateVisitor);
            this.context = context;
            this.methodInfo = methodInfo;
        }

        private void mutateObjectReferenceReturn() {
            if (this.shouldMutate("object reference", "[see docs for details]")) {
                Type returnType = this.methodInfo.getReturnType();
                super.visitLdcInsn(returnType);
                super.visitMethodInsn(184, OBJECT_MUTATION_METHOD.getClassName(), OBJECT_MUTATION_METHOD.getMethodName(), OBJECT_MUTATION_METHOD.getMethodDescriptor(), false);
                super.visitTypeInsn(192, returnType.getInternalName());
            }
            super.visitInsn(176);
        }

        private void mutatePrimitiveDoubleReturn() {
            if (this.shouldMutate("primitive double", "(x != NaN)? -(x + 1) : -1 ")) {
                Label label = new Label();
                super.visitInsn(92);
                super.visitInsn(92);
                super.visitInsn(152);
                super.visitJumpInsn(153, label);
                super.visitInsn(88);
                super.visitInsn(14);
                super.visitLabel(label);
                super.visitInsn(15);
                super.visitInsn(99);
                super.visitInsn(119);
                super.visitInsn(175);
            }
        }

        private void mutatePrimitiveFloatReturn() {
            if (this.shouldMutate("primitive float", "(x != NaN)? -(x + 1) : -1 ")) {
                Label label = new Label();
                super.visitInsn(89);
                super.visitInsn(89);
                super.visitInsn(150);
                super.visitJumpInsn(153, label);
                super.visitInsn(87);
                super.visitInsn(11);
                super.visitLabel(label);
                super.visitInsn(12);
                super.visitInsn(98);
                super.visitInsn(118);
                super.visitInsn(174);
            }
        }

        private void mutatePrimitiveIntegerReturn() {
            if (this.shouldMutate("primitive boolean/byte/short/integer", "(x == 1) ? 0 : x + 1")) {
                Label label = new Label();
                super.visitInsn(89);
                super.visitInsn(4);
                super.visitJumpInsn(159, label);
                super.visitInsn(4);
                super.visitInsn(96);
                super.visitInsn(172);
                super.visitLabel(label);
                super.visitInsn(3);
                super.visitInsn(172);
            }
        }

        private void mutatePrimitiveLongReturn() {
            if (this.shouldMutate("primitive long", "x + 1")) {
                super.visitInsn(10);
                super.visitInsn(97);
                super.visitInsn(173);
            }
        }

        private boolean shouldMutate(String type, String replacement) {
            String description = String.format(DESCRIPTION_MESSAGE_PATTERN, type, replacement);
            MutationIdentifier mutationId = this.context.registerMutation(ReturnValuesMutator.this, description);
            return this.context.shouldMutate(mutationId);
        }

        @Override
        public void visitInsn(int opcode) {
            switch (opcode) {
                case 172: {
                    this.mutatePrimitiveIntegerReturn();
                    break;
                }
                case 173: {
                    this.mutatePrimitiveLongReturn();
                    break;
                }
                case 174: {
                    this.mutatePrimitiveFloatReturn();
                    break;
                }
                case 175: {
                    this.mutatePrimitiveDoubleReturn();
                    break;
                }
                case 176: {
                    this.mutateObjectReferenceReturn();
                    break;
                }
                default: {
                    super.visitInsn(opcode);
                }
            }
        }
    }

    private static final class ObjectReferenceReplacer {
        private ObjectReferenceReplacer() {
        }

        private Object replaceObjectInstance(Object object, Class<?> declaredReturnType) {
            if (Boolean.class == declaredReturnType) {
                if (Boolean.TRUE.equals(object)) {
                    return Boolean.FALSE;
                }
                return Boolean.TRUE;
            }
            if (Integer.class == declaredReturnType) {
                Integer intValue = (Integer)object;
                if (intValue == null) {
                    return 1;
                }
                if (intValue == 1) {
                    return 0;
                }
                return intValue + 1;
            }
            if (Long.class == declaredReturnType) {
                Long longValue = (Long)object;
                if (longValue == null) {
                    return 1L;
                }
                return longValue + 1L;
            }
            if (Object.class == declaredReturnType) {
                if (object != null) {
                    return null;
                }
                return new Object();
            }
            if (object == null) {
                throw new RuntimeException("Mutated return of null object to throwing a runtime exception");
            }
            return null;
        }
    }

    private static final class ObjectMutationMethod {
        private final String mutatorMethodName;
        private final String mutatorInternalName;
        private final String mutationMethodDescriptor;

        ObjectMutationMethod() {
            Type mutatorType = Type.getType(ReturnValuesMutator.class);
            this.mutatorInternalName = mutatorType.getInternalName();
            this.mutatorMethodName = "mutateObjectInstance";
            Type objectType = Type.getType(Object.class);
            Type classType = Type.getType(Class.class);
            this.mutationMethodDescriptor = Type.getMethodDescriptor(objectType, objectType, classType);
        }

        public String getClassName() {
            return this.mutatorInternalName;
        }

        public String getMethodDescriptor() {
            return this.mutationMethodDescriptor;
        }

        public String getMethodName() {
            return this.mutatorMethodName;
        }
    }
}

