/*
 * Decompiled with CFR 0.152.
 */
package org.pitest.mutationtest.engine.gregor.mutators.rv;

import org.pitest.mutationtest.engine.MutationIdentifier;
import org.pitest.mutationtest.engine.gregor.MethodMutatorFactory;
import org.pitest.mutationtest.engine.gregor.MutationContext;
import org.pitest.reloc.asm.MethodVisitor;

class ABSMethodVisitor
extends MethodVisitor {
    private final MethodMutatorFactory factory;
    private final MutationContext context;

    ABSMethodVisitor(MethodMutatorFactory factory, MutationContext context, MethodVisitor delegateMethodVisitor) {
        super(589824, delegateMethodVisitor);
        this.factory = factory;
        this.context = context;
    }

    private boolean shouldMutate(String message) {
        if (this.context.getClassInfo().isEnum()) {
            return false;
        }
        MutationIdentifier newId = this.context.registerMutation(this.factory, message);
        return this.context.shouldMutate(newId);
    }

    @Override
    public void visitVarInsn(int opcode, int var) {
        this.mv.visitVarInsn(opcode, var);
        switch (opcode) {
            case 21: {
                if (!this.shouldMutate("Negated integer local variable number " + var)) break;
                this.mv.visitInsn(116);
                break;
            }
            case 23: {
                if (!this.shouldMutate("Negated float local variable number " + var)) break;
                this.mv.visitInsn(118);
                break;
            }
            case 22: {
                if (!this.shouldMutate("Negated long local variable number " + var)) break;
                this.mv.visitInsn(117);
                break;
            }
            case 24: {
                if (!this.shouldMutate("Negated double local variable number " + var)) break;
                this.mv.visitInsn(119);
                break;
            }
        }
    }

    @Override
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        this.mv.visitFieldInsn(opcode, owner, name, desc);
        if (opcode == 180) {
            if (desc.equals("I") && this.shouldMutate("Negated integer field " + name)) {
                this.mv.visitInsn(116);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Negated float field " + name)) {
                this.mv.visitInsn(118);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Negated long field " + name)) {
                this.mv.visitInsn(117);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Negated double field " + name)) {
                this.mv.visitInsn(119);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Negated byte field " + name)) {
                this.mv.visitInsn(116);
                this.mv.visitInsn(145);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Negated short field " + name)) {
                this.mv.visitInsn(116);
                this.mv.visitInsn(147);
                return;
            }
        }
        if (opcode == 178) {
            if (desc.equals("I") && this.shouldMutate("Negated integer static field " + name)) {
                this.mv.visitInsn(116);
                return;
            }
            if (desc.equals("F") && this.shouldMutate("Negated float static field " + name)) {
                this.mv.visitInsn(118);
                return;
            }
            if (desc.equals("J") && this.shouldMutate("Negated long static field " + name)) {
                this.mv.visitInsn(117);
                return;
            }
            if (desc.equals("D") && this.shouldMutate("Negated double static field " + name)) {
                this.mv.visitInsn(119);
                return;
            }
            if (desc.equals("B") && this.shouldMutate("Negated byte static field " + name)) {
                this.mv.visitInsn(116);
                this.mv.visitInsn(145);
                return;
            }
            if (desc.equals("S") && this.shouldMutate("Negated short static field " + name)) {
                this.mv.visitInsn(116);
                this.mv.visitInsn(147);
                return;
            }
        }
    }

    @Override
    public void visitInsn(int opcode) {
        this.mv.visitInsn(opcode);
        switch (opcode) {
            case 46: {
                if (!this.shouldMutate("Negated integer array field")) break;
                this.mv.visitInsn(116);
                break;
            }
            case 48: {
                if (!this.shouldMutate("Negated float array field")) break;
                this.mv.visitInsn(118);
                break;
            }
            case 47: {
                if (!this.shouldMutate("Negated long array field")) break;
                this.mv.visitInsn(117);
                break;
            }
            case 49: {
                if (!this.shouldMutate("Negated double array field")) break;
                this.mv.visitInsn(119);
                break;
            }
            case 51: {
                if (!this.shouldMutate("Negated byte array field")) break;
                this.mv.visitInsn(116);
                this.mv.visitInsn(145);
                break;
            }
            case 53: {
                if (!this.shouldMutate("Negated short array field")) break;
                this.mv.visitInsn(116);
                this.mv.visitInsn(147);
                break;
            }
        }
    }
}

